% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-Model.R
\name{predict_bkt}
\alias{predict_bkt}
\title{Predict}
\usage{
predict_bkt(model, data_path = NULL, data = NULL)
}
\arguments{
\item{model}{A trained BKT model object. The model must have been previously fitted using
the \code{fit()} function. If the model is not fitted, an error will be raised.}

\item{data_path}{Character. The file path to the dataset on which predictions will be made.
If this is provided, the function will read data from the file.}

\item{data}{Data frame. A pre-loaded dataset to be used for predictions. This can be used
instead of specifying \code{data_path}.}
}
\value{
A data frame containing the original data with two additional columns:
\code{correct_predictions} and \code{state_predictions}.
}
\description{
Predict outcomes using a fitted BKT model.
This function uses a trained Bayesian Knowledge Tracing (BKT) model to make predictions
on new data. The predictions include both the likelihood of a correct response (\code{correct_predictions})
and the estimated hidden state of the learner's knowledge (\code{state_predictions}).
}
\examples{
\donttest{
model <- bkt(seed = 42)
fit_model <- fit(model, data_path = "ct.csv")
predictions <- predict_bkt(fit_model, data_path = "ct_test.csv")
head(predictions)
}
}
