% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dosage2vcf.R
\name{dosage2vcf}
\alias{dosage2vcf}
\title{Convert DArTag Dosage and Counts to VCF}
\usage{
dosage2vcf(dart.report, dart.counts, ploidy, output.file)
}
\arguments{
\item{dart.report}{Path to the DArT dosage report .csv file. Typically contains "Dosage Report" in the file name.}

\item{dart.counts}{Path to the DArT counts .csv file. Typically contains "Counts" in the file name.}

\item{ploidy}{The ploidy of the species being analyzed}

\item{output.file}{output file name and path}
}
\value{
A vcf file
}
\description{
This function will convert the DArT Dosage Report and Counts files to VCF format
}
\details{
This function will convert the Dosage Report and Counts files from DArT into a VCF file.
These two files are received directly from DArT for a given sequencing project.
The output file will be saved to the location and with the name that is specified.
The VCF format is v4.3
}
\examples{
## Use file paths for each file on the local system

#The files are directly from DArT for a given sequencing project.
#The are labeled with Dosage_Report or Counts in the file names.

#Temp location (only for example)
output_file <- tempfile()

dosage2vcf(dart.report = system.file("iris_DArT_Allele_Dose_Report_small.csv", package = "BIGr"),
           dart.counts = system.file("iris_DArT_Counts_small.csv", package = "BIGr"),
           ploidy = 2,
           output.file = output_file)

# Removing the output for the example
rm(output_file)

##The function will output the converted VCF using information from the DArT files

}
