#' @title bcbExpectA
#' 
#' @description Market Expectations with annual reference.
#' 
#' 
#' @param variables Possible options: "Media", "Mediana", "DesvioPadrao",
#' "CoeficienteVariacao", "Minimo", "Maximo".
#' @param start Initial date at which the data was projected, in ISO format.
#' @param end Final date at which the data was projected, in ISO format.
#' @param indicator  A string. Available indicator.
#' @param limit A integer. A limint of data in request, top is 10000.
#'
#'
#' @import rjson
#' @return A data.frame.
#' @export 
#'
#' 
#' @note The available indicators are: Balanca comercial, Balanco de pagamentos, Fiscal, IGP-DI,
#'   IGP-M, INPC, IPA-DI, IPA-M, IPCA, IPCA-15, IPC-FIPE, Precos administrados por contrato e 
#'   monitorado, Producao industrial, PIB Industrial, PIB Servicos, PIB Total, Meta para taxa 
#'   over-selic e Taxa de cambio.  
#'   
#'   
#'   In collaboration with Angelo Salton <https://github.com/angelosalton>.
#' 
#' @examples 
#'  # bcbExpectA()
#' 
#' 
#' 



bcbExpectA <- function(indicator = 'IPCA',limit = 100, variables = c("Media","Mediana","DesvioPadrao","CoeficienteVariacao","Minimo","Maximo","numeroRespondentes",'baseCalculo'), start, end ){

    
    indicator = str_replace_all(indicator," ","%20")
    
    if(limit > 10000 | limit < 0)stop("You need provid a limit in between 0 and 10000!")
    # variaveis
    variaveis_a <- paste("filter=Indicador%20eq%20'",indicator,"'",sep="")
    variaveis_b <- paste("top=",limit,sep="")
    variaveis_c <- paste("Indicador", "IndicadorDetalhe", "Data",
                         "DataReferencia", variables, sep = ",")
    
    if(missing(start) & missing(end)){
        timespan <- ""
    }else if(missing(start) & !missing(end)){
        timespan <- paste0("%20and%20Data%20gt%20'", start,"'")
    }else if(!missing(start) & !missing(end)){
        timespan <- paste0("%20and%20Data%20gt%20'", start, "'%20and%20", "Data%20lt%20'", end,"'")
    }else{
        timespan <- paste0("%20and%20Data%20lt%20'", end,"'")  
    }
    
    
    baseurl <- "https://olinda.bcb.gov.br/olinda/servico/Expectativas/versao/v1/odata/"
    query_url <- paste(baseurl, "ExpectativasMercadoAnuais", "?$",variaveis_b,"&$",variaveis_a,timespan,
                       "&$select=",variaveis_c, sep = "", collapse = "")
    
   
    data <- fromJSON(file = query_url)$value
    data <- do.call("rbind", lapply(data, as.data.frame))
    return(data)
}
