% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlier}
\alias{outlier}
\title{Identify Outliers Using Boxplot Heuristic}
\usage{
outlier(x, coef = 1.5, rpt = FALSE)
}
\arguments{
\item{x}{Numeric vector for which outliers are to be detected.}

\item{coef}{Numeric value for boxplot heuristic coefficient (default is 1.5). Higher values result in fewer points being classified as outliers.}

\item{rpt}{Logical. If \code{FALSE} (default), returns a logical vector indicating which elements of \code{x} are outliers. If \code{TRUE}, returns the calculated lower and upper limits for outlier detection, identified by \code{x < rpt[1] | x > rpt[2]}.}
}
\value{
If \code{rpt = FALSE}, returns a logical vector indicating outliers. If \code{rpt = TRUE}, returns a numeric vector of length 2 giving lower and upper limits for outlier detection
}
\description{
Detects outliers in a numeric vector using the boxplot heuristic (default, outside 1.5 times the IQR from the 1st and 3rd quartiles).
Handles missing values (NA) automatically.
}
\examples{
set.seed(1)
vals <- c(rnorm(100), 10, -10)
outlier(vals)
outlier(vals, rpt = TRUE)

}
