% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_storage.R
\docType{class}
\name{az_storage}
\alias{az_storage}
\title{Storage account resource class}
\description{
Class representing a storage account, exposing methods for working with it.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new storage object. See 'Initialization'.
\item \code{list_keys()}: Return the access keys for this account.
\item \code{get_account_sas(...)}: Return an account shared access signature (SAS). See 'Creating a shared access signature' below.
\item \code{get_user_delegation_key(...)}: Returns a key that can be used to construct a user delegation SAS.
\item \code{get_user_delegation_sas(...)}: Return a user delegation SAS.
\item \code{revoke_user_delegation_keys()}: Revokes all user delegation keys for the account. This also renders all SAS's obtained via such keys invalid.
\item \code{get_blob_endpoint(key, sas)}: Return the account's blob storage endpoint, along with an access key and/or a SAS. See 'Endpoints' for more details
\item \code{get_file_endpoint(key, sas)}: Return the account's file storage endpoint.
\item \code{regen_key(key)}: Regenerates (creates a new value for) an access key. The argument \code{key} can be 1 or 2.
}
}

\section{Initialization}{

Initializing a new object of this class can either retrieve an existing storage account, or create a account on the host. Generally, the best way to initialize an object is via the \code{get_storage_account}, \code{create_storage_account} or \code{list_storage_accounts} methods of the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class, which handle the details automatically.
}

\section{Creating a shared access signature}{

Note that you don't need to worry about this section if you have been \emph{given} a SAS, and only want to use it to access storage.

AzureStor supports generating three kinds of SAS: account, service and user delegation. An account SAS can be used with any type of storage. A service SAS can be used with blob and file storage, whle a user delegation SAS can be used with blob and ADLS2 storage.

To create an account SAS, call the \code{get_account_sas()} method. This has the following signature:

\if{html}{\out{<div class="sourceCode">}}\preformatted{get_account_sas(key=self$list_keys()[1], start=NULL, expiry=NULL, services="bqtf", permissions="rl",
                resource_types="sco", ip=NULL, protocol=NULL)
}\if{html}{\out{</div>}}

To create a service SAS, call the \code{get_service_sas()} method, which has the following signature:

\if{html}{\out{<div class="sourceCode">}}\preformatted{get_service_sas(key=self$list_keys()[1], resource, service, start=NULL, expiry=NULL, permissions="r",
                resource_type=NULL, ip=NULL, protocol=NULL, policy=NULL, snapshot_time=NULL)
}\if{html}{\out{</div>}}

To create a user delegation SAS, you must first create a user delegation \emph{key}. This takes the place of the account's access key in generating the SAS. The \code{get_user_delegation_key()} method has the following signature:

\if{html}{\out{<div class="sourceCode">}}\preformatted{get_user_delegation_key(token=self$token, key_start=NULL, key_expiry=NULL)
}\if{html}{\out{</div>}}

Once you have a user delegation key, you can use it to obtain a user delegation sas. The \code{get_user_delegation_sas()} method has the following signature:

\if{html}{\out{<div class="sourceCode">}}\preformatted{get_user_delegation_sas(key, resource, start=NULL, expiry=NULL, permissions="rl",
                        resource_type="c", ip=NULL, protocol=NULL, snapshot_time=NULL)
}\if{html}{\out{</div>}}

(Note that the \code{key} argument for this method is the user delegation key, \emph{not} the account key.)

To invalidate all user delegation keys, as well as the SAS's generated with them, call the \code{revoke_user_delegation_keys()} method. This has the following signature:

\if{html}{\out{<div class="sourceCode">}}\preformatted{revoke_user_delegation_keys()
}\if{html}{\out{</div>}}

See the \link[=sas]{Shared access signatures} page for more information about this topic.
}

\section{Endpoints}{

The client-side interaction with a storage account is via an \emph{endpoint}. A storage account can have several endpoints, one for each type of storage supported: blob, file, queue and table.

The client-side interface in AzureStor is implemented using S3 classes. This is for consistency with other data access packages in R, which mostly use S3. It also emphasises the distinction between Resource Manager (which is for interacting with the storage account itself) and the client (which is for accessing files and data stored in the account).

To create a storage endpoint independently of Resource Manager (for example if you are a user without admin or owner access to the account), use the \link{blob_endpoint} or \link{file_endpoint} functions.

If a storage endpoint is created without an access key and SAS, only public (anonymous) access is possible.
}

\examples{
\dontrun{

# recommended way of retrieving a resource: via a resource group object
stor <- resgroup$get_storage_account("mystorage")

# list account access keys
stor$list_keys()

# regenerate a key
stor$regen_key(1)

# storage endpoints
stor$get_blob_endpoint()
stor$get_file_endpoint()

}
}
\seealso{
\link{blob_endpoint}, \link{file_endpoint},
\link{create_storage_account}, \link{get_storage_account}, \link{delete_storage_account}, \link{Date}, \link{POSIXt}

\href{https://learn.microsoft.com/en-us/rest/api/storagerp/}{Azure Storage Provider API reference},
\href{https://learn.microsoft.com/en-us/rest/api/storageservices/}{Azure Storage Services API reference}

\href{https://learn.microsoft.com/en-us/rest/api/storageservices/create-account-sas}{Create an account SAS},
\href{https://learn.microsoft.com/en-us/rest/api/storageservices/create-user-delegation-sas}{Create a user delegation SAS},
\href{https://learn.microsoft.com/en-us/rest/api/storageservices/create-service-sas}{Create a service SAS}
}
