% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_group.R
\docType{class}
\name{az_group}
\alias{az_group}
\title{Group in Azure Active Directory}
\format{
An R6 object of class \code{az_group}, inheriting from \code{az_object}.
}
\description{
Class representing an AAD group.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for this group.
\item \code{type}: always "group" for a group object.
\item \code{properties}: The group properties.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new group object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete a group. By default, ask for confirmation first.
\item \code{update(...)}: Update the group information in Azure Active Directory.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the group.
\item \code{sync_fields()}: Synchronise the R object with the app data in Azure Active Directory.
\item \code{list_members(type=c("user", "group", "application", "servicePrincipal"), filter=NULL, n=Inf)}: Return a list of all members of this group. Specify the \code{type} argument to limit the result to specific object type(s).
\item \code{list_owners(type=c("user", "group", "application", "servicePrincipal"), filter=NULL, n=Inf)}: Return a list of all owners of this group. Specify the \code{type} argument to limit the result to specific object type(s).
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{create_group} and \code{get_group} methods of the \link{ms_graph} and \link{az_app} classes. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to create the actual group.
}

\section{List methods}{

All \verb{list_*} methods have \code{filter} and \code{n} arguments to limit the number of results. The former should be an \href{https://learn.microsoft.com/en-us/graph/query-parameters#filter-parameter}{OData expression} as a string to filter the result set on. The latter should be a number setting the maximum number of (filtered) results to return. The default values are \code{filter=NULL} and \code{n=Inf}. If \code{n=NULL}, the \code{ms_graph_pager} iterator object is returned instead to allow manual iteration over the results.

Support in the underlying Graph API for OData queries is patchy. Not all endpoints that return lists of objects support filtering, and if they do, they may not allow all of the defined operators. If your filtering expression results in an error, you can carry out the operation without filtering and then filter the results on the client side.
}

\examples{
\dontrun{

gr <- get_graph_login()
usr <- gr$get_user("myname@aadtenant.com")

grps <- usr$list_group_memberships()
grp <- gr$get_group(grps[1])

grp$list_members()
grp$list_owners()

# capping the number of results
grp$list_members(n=10)

# get the pager object for a listing method
pager <- grp$list_members(n=NULL)
pager$value

}
}
\seealso{
\link{ms_graph}, \link{az_app}, \link{az_user}, \link{az_object}

\href{https://learn.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://learn.microsoft.com/en-us/graph/api/overview?view=graph-rest-1.0}{REST API reference}
}
