% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_auspol.R
\name{get_auspol}
\alias{get_auspol}
\title{Retrieve a csv dataset from the australian_politicians repository.}
\usage{
get_auspol(df)
}
\arguments{
\item{df}{A character string used to request an Australian politicians dataset. *See Request Codes* below.}
}
\value{
The requested dataset using \code{df} to a user assigned name.
}
\description{
`get_auspol()` downloads a requested Australian politicians .csv dataset using an associated argument.
}
\details{
There are four request codes: `all`, `allbyparty`, `mps` and `senators`.

The specifics of these are:

- `all` requests the australian_politicians-all.csv dataset.
- `allbyparty` requests the australian_politicians-all-by_party.csv dataset.
- `mps` requests the australian_politicians-mps-by_division.csv dataset.
- `senators` requests the australian_politicians-senators-by_state.csv dataset.

An incorrect request (an argument not associated with a dataset or non-character
string argument) will stop function processes and return an error message.
}
\examples{
\dontrun{
# Request the Senators by State dataset.
senators_df <- get_auspol("senators")

# Preview first 10 observations of the dataset.
head(senators_df, 10)
}
}
\seealso{
`show_datacodes()` function help.
}
