% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_argentine_senators.R
\name{get_argentine_senators}
\alias{get_argentine_senators}
\title{Get Current and Past Senators of Argentina}
\usage{
get_argentine_senators()
}
\value{
A data frame (tibble) with the following columns:
\itemize{
  \item \code{id}: Unique identifier of the senator.
  \item \code{nombre}: Full name of the senator.
  \item \code{provincia}: Province represented.
  \item \code{partido}: Political party.
  \item \code{inicio}: Start date of the legal period (Date).
  \item \code{fin}: End date of the legal period (Date).
}
Returns \code{NULL} if the API is unavailable or returns an error.
}
\description{
This function retrieves a list of senators from the Argentine Senate API endpoint:
`https://api.argentinadatos.com/v1/senado/senadores`. The result includes name, province,
party affiliation, and their legal term of office. The results are sorted by the start
of their legal term in descending order (most recent first).
}
\details{
The function parses the nested JSON structure returned by the API, extracts the period data,
and ensures that `inicio` and `fin` are treated as proper `Date` objects. The data is sorted
by `inicio` in descending order to prioritize currently active or recently active senators.
}
\note{
Requires internet access. Be cautious with malformed or missing date fields.
}
\examples{
\dontrun{
senators <- get_argentine_senators()
head(senators)

# Filter only currently active senators
active <- dplyr::filter(senators, Sys.Date() <= fin)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{arrange}}
}
