% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_argentina_energy_use.R
\name{get_argentina_energy_use}
\alias{get_argentina_energy_use}
\title{Get Argentina's Energy Use (kg of oil equivalent per capita) from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/EG.USE.PCAP.KG.OE}
}
\usage{
get_argentina_energy_use()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name (e.g., "Energy use (kg of oil equivalent per capita)")
  \item \code{country}: Country name ("Argentina")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Energy use in kilograms of oil equivalent per capita
}
}
\description{
Retrieves Argentina's energy use per capita, measured in kilograms of oil equivalent,
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{EG.USE.PCAP.KG.OE}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
if (interactive()) {
  get_argentina_energy_use()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
