% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFlexTables.R
\name{addFlexTables}
\alias{addFlexTables}
\title{Read Word document with bookmarks and create other Word document with rendered tables in place.}
\usage{
addFlexTables(docxIn, docxOut, FlexTables = list(), debug = F, ...)
}
\arguments{
\item{docxIn}{String of length one; path to Word file with bookmarks.}

\item{docxOut}{String of length one; path for output Word file.}

\item{FlexTables}{Named list of FlexTables; Tables to be inserted into the Word file}

\item{debug}{Boolean of length one; If \code{True} then \code{\link[base]{browser}()} is called at the beginning of the function}

\item{...}{Parameters to be sent to other methods (mainly \code{\link[ReporteRs]{addFlexTable}})}
}
\value{
Path to the rendered Word file if the operation was successfull.
}
\description{
This function is basically a loop wrapper around \code{\link[ReporteRs]{addFlexTable}} function.
}
\examples{
library(ReporteRs)
ft_mtcars <- vanilla.table(mtcars)
ft_iris <- vanilla.table(iris)
FT <- list(ft_mtcars=ft_mtcars,ft_iris=ft_iris)
addFlexTables(
  paste(examplePath(),'templates/templateFT.docx',sep = ''),
  paste(examplePath(),'results/resultFT.docx',sep = ''),
  FT)

}
