% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess-strand-flip.R
\name{assess.pgs.vcf.allele.match}
\alias{assess.pgs.vcf.allele.match}
\title{Assess PGS allele match to VCF allele}
\usage{
assess.pgs.vcf.allele.match(
  vcf.ref.allele,
  vcf.alt.allele,
  pgs.ref.allele,
  pgs.effect.allele,
  return.indels.as.missing = FALSE,
  return.ambiguous.as.missing = FALSE,
  max.strand.flips = 0
)
}
\arguments{
\item{vcf.ref.allele}{A character vector of singular VCF reference (REF) alleles.}

\item{vcf.alt.allele}{A character vector of VCF alternative (ALT) alleles. Multiple alleles at a multiallelic site must be separated by commas.}

\item{pgs.ref.allele}{A character vector of singular PGS reference alleles aka "non-effect" or "other" alleles.}

\item{pgs.effect.allele}{A character vector of singular PGS effect alleles.}

\item{return.indels.as.missing}{A logical value indicating whether to return NA for INDEL alleles with detected mismatches. Default is \code{FALSE}.}

\item{return.ambiguous.as.missing}{A logical value indicating whether to return NA for ambiguous cases where both a strand flip and effect switch are possible,
or no strand flip is detected and a mismatch cannot be resolved. Default is \code{FALSE}.}

\item{max.strand.flips}{An integer indicating the number of non-ambiguous strand flips that must be present to implement the discarding all allele matches labeled "ambiguous_flip". Only applies if \code{return.ambiguous.as.missing == TRUE}.
Defaults to \code{0}, meaning that no strand flips are allowed. Allele matches labeled "unresolved_mismatch" are not affected by this parameter.}
}
\value{
A list containing the match assessment, a new PGS effect allele, and a new PGS other allele.

\strong{Output Structure}

The outputed list contains the following elements:
\itemize{
\item \code{match.status}: A character vector indicating the match status for each pair of allele pairs. Possible values are \code{default_match}, \code{effect_switch}, \code{strand_flip}, \code{effect_switch_with_strand_flip}, \code{ambiguous_flip}, \code{indel_mismatch}, and \code{unresolved_mismatch}.
\item \code{new.pgs.effect.allele}: A character vector of new PGS effect alleles based on the match status. If the match status is \code{default_match}, \code{effect_switch} or \code{missing_allele}, the original PGS effect allele is returned.
If the match status is \code{strand_flip} or \code{effect_switch_with_strand_flip} the flipped PGS effect allele is returned. If the match status is \code{ambiguous_flip}, \code{indel_mismatch}, or \code{unresolved_mismatch},
the return value is either the original allele or NA as dictated by the \code{return.indels.as.missing}, \code{return.ambiguous.as.missing}, and \code{max.strand.flips} parameters.
\item \code{new.pgs.other.allele}: A character vector of new PGS other alleles based on the match status, following the same logic as \code{new.pgs.effect.allele}.
}

The match.status output indicates the following:
\itemize{
\item \code{default_match}: The default PGS reference allele matches the VCF REF allele and the default PGS effect allele matches one of the VCF ALT alleles.
\item \code{effect_switch}: The PGS effect allele matches the VCF REF allele and the PGS reference allele matches one of the VCF ALT alleles.
\item \code{strand_flip}: The PGS reference and effect alleles match their respective VCF pairs when flipped.
\item \code{effect_switch_with_strand_flip}: The PGS effect allele matches the VCF REF allele and the PGS reference allele matches one of the VCF ALT alleles when flipped.
\item \code{ambiguous_flip}: Both an effect switch and a strand flip have been detected. This is an ambiguous case caused by palindromic SNPs.
\item \code{indel_mismatch}: A mismatch was detected between pairs of alleles where at least one was an INDEL. INDEL alleles are not supported for strand flip assessment.
\item \code{unresolved_mismatch}: A mismatch was detected between pairs of non-INDEL alleles that could not be resolved by an effect switch or flipping the PGS alleles.
\item \code{missing_allele}: One of the four alleles is missing, making it impossible to assess the match.
}
}
\description{
Assess whether PGS reference and effect alleles match provided VCF reference and alternative alleles.
Mismatches are checked for potential switching of effect and reference PGS alleles (cases where the effect allele is the REF VCF allele)
and are evaluated for DNA strand flips (by flipping the PGS alleles). INDEL alleles are not supported for strand flip assessment.
}
\examples{
# Example data demonstrating the following cases in each vector element:
# 1. no strand flips
# 2. effect allele switch
# 3. strand flip
# 4. effect allele switch AND strand flip
# 5. palindromic (ambiguous) alleles
# 6. unresolved mismatch
vcf.ref.allele <- c('A', 'A', 'A', 'A', 'A', 'A');
vcf.alt.allele <- c('G', 'G', 'G', 'G', 'T', 'G');
pgs.ref.allele <- c('A', 'G', 'T', 'C', 'T', 'A');
pgs.effect.allele <- c('G', 'A', 'C', 'T', 'A', 'C');
assess.pgs.vcf.allele.match(vcf.ref.allele, vcf.alt.allele, pgs.ref.allele, pgs.effect.allele);
}
