% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_length_summary.R
\name{sequence_length_summary}
\alias{sequence_length_summary}
\title{Summarize Sequence Lengths}
\usage{
sequence_length_summary(sequences)
}
\arguments{
\item{sequences}{A character vector where each element is a sequence of elements separated by spaces.}
}
\value{
A data frame with the following columns:
\item{mean_seq_elements}{The mean length of the sequences.}
\item{sd_seq_elements}{The standard deviation of the sequence lengths.}
\item{median_seq_elements}{The median length of the sequences.}
\item{min_seq_elements}{The minimum length of the sequences.}
\item{max_seq_elements}{The maximum length of the sequences.}
\item{distinct_elements}{The number of distinct elements across all sequences.}
\item{pvalue_distinct_elements}{The p-value comparing the true number of distinct elements to shuffled sequences.}
}
\description{
This function calculates summary statistics for the lengths of sequences of elements, including mean, standard deviation, median, minimum, and maximum lengths. It also counts the number of distinct elements and compares this to shuffled sequences.
}
\examples{
sequences <- c('hello world', 'hello world hello', 'hello world hello world')
sequence_length_summary(sequences)
}
