% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_sequences.R
\name{long_to_sequences}
\alias{long_to_sequences}
\title{Convert Long Format to Sequences}
\usage{
long_to_sequences(
  sequences_long,
  elements = "element",
  sequence_identifier = "sequence_identifier",
  start_time = "start_time",
  end_time = "end_time",
  covariates = NULL
)
}
\arguments{
\item{sequences_long}{A data frame in long format containing the sequences.}

\item{elements}{Column name for elements that should be combined into sequences.}

\item{sequence_identifier}{Column name with the sequence identifier.}

\item{start_time}{Column name with the start time.}

\item{end_time}{Column name with the end time.}

\item{covariates}{A vector with column names of the covariates. Defaults to NULL.}
}
\value{
A data frame with sequences, start time, end time, and aggregated covariates.
}
\description{
This function converts a data frame in long format into sequences by combining all rows with the same sequence identifier. It also aggregates covariates if provided.
}
\examples{
sequences_long <- data.frame(sequence_identifier = c(1, 1, 2, 2, 2),
                             element = c('A', 'B', 'A', 'B', 'C'),
                             start_time = c(1, 2, 1, 2, 3),
                             end_time = c(2, 3, 2, 3, 4),
                             covariate1 = c('X', 'Y', 'X', 'Y', 'Z'),
                             covariate2 = c('M', 'N', 'M', 'N', 'O'))
long_to_sequences(sequences_long,
                  elements = 'element',
                  sequence_identifier = 'sequence_identifier',
                  start_time = 'start_time',
                  covariates = c('covariate1', 'covariate2'))
}
