% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_counts.R
\name{calculate_transition_counts}
\alias{calculate_transition_counts}
\title{Calculate Transition Counts from Sequences}
\usage{
calculate_transition_counts(sequences)
}
\arguments{
\item{sequences}{A vector of character strings, where each string represents a sequence of elements separated by spaces. Elements should be labeled with prefixes (e.g., "e1", "e2").}
}
\value{
A matrix where the entry at \code{[i, j]} represents the number of times an element labeled \code{i} is followed by an element labeled \code{j} across all sequences.
}
\description{
This function calculates the transition counts between elements in a set of sequences. It creates a matrix where each element represents the number of times a transition occurs from one element to another.
}
\details{
The function assumes that elements in the sequences are labeled with prefixes (e.g., "e1", "e2"), which are stripped to extract the integer labels for counting. The matrix is initialized to be of size \code{num_elements x num_elements}, where \code{num_elements} should be defined in your script or session. Ensure that \code{num_elements} is set to the correct number of unique elements before running this function.
}
\examples{
sequences <- c("e1 e2 e3", "e2 e3 e1", "e1 e3")
num_elements <- 3
calculate_transition_counts(sequences)
}
