% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_functions.R
\name{import_seurat_maelstrom}
\alias{import_seurat_maelstrom}
\title{import_seurat_Maelstrom}
\usage{
import_seurat_maelstrom(
  seurat_object,
  cluster_id = "seurat_clusters",
  maelstrom_file = "~/final.out.txt",
  return_df = FALSE
)
}
\arguments{
\item{seurat_object}{object}

\item{cluster_id}{ID used for finding clusters of cells}

\item{maelstrom_file}{maelstrom final.out.txt file}

\item{return_df}{return both the seurat object and a dataframe with maelstrom scores as a list}
}
\value{
seurat object with the maelstrom motif scores addes as an assay
}
\description{
load Maelstrom enriched motifs
}
\examples{
sce_small <- readRDS(system.file("extdata","sce_small.Rds",package = 'AnanseSeurat'))
maelstromfile_path <- system.file("extdata","maelstrom","final.out.txt",package = 'AnanseSeurat')
sce_small <- import_seurat_maelstrom(sce_small, maelstrom_file = maelstromfile_path)
}
