% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{fontName}
\alias{fontName}
\alias{fontName<-}
\title{Extract or replace a font name}
\usage{
fontName(x)

fontName(x) <- value
}
\arguments{
\item{x}{An \code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}} for which the font name
needs to be changed.}

\item{value}{A \code{character} string specifying the name you
wish to use for the font.}
}
\value{
Returns the font name. In case of the replace function, a copy
of \code{x} is returned with the name replaced by '\code{value}'.
}
\description{
Extract or replace a font name from an \code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}}
object.
}
\details{
The name of a font is embeded at multiple locations of an \code{\link[=AmigaBitmapFontSet]{AmigaBitmapFontSet()}}
object. This function can be used to extract or replace the font name
correctly. This is also the name that will be used when writing the
font to a file with \code{\link[=write.AmigaBitmapFontSet]{write.AmigaBitmapFontSet()}}.
}
\examples{
data(font_example)

## show the name of the example font:
fontName(font_example)

## This is how you change the name into "foo"
fontName(font_example) <- "foo"

## see it worked:
fontName(font_example)
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{c}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{write.AmigaBitmapFont}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
