% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Air_methods.R
\name{Air}
\alias{Air}
\title{Unified Interface for \code{\link{AirHOLP}} and \code{\link{AirOLS}}}
\usage{
Air(
  X,
  y,
  m = NULL,
  screening_threshold = NULL,
  penalty = 10,
  penalty_type = c("adaptive", "fixed", "both"),
  method = c("auto", "AirHOLP", "AirOLS")
)
}
\arguments{
\item{X}{Numeric predictor matrix (\eqn{n \times p}).}

\item{y}{Numeric response vector of length \eqn{n}.}

\item{m}{Integer specifying the number of coefficients retained at each
adaptive-penalty iteration (default \eqn{n/\log(n)} capped at \eqn{p-1}).}

\item{screening_threshold}{Integer specifying the number of screened
features to display in summary.}

\item{penalty}{Numeric scalar or vector with ridge penalty value(s)
(default \eqn{10}).}

\item{penalty_type}{One of \code{"adaptive"}, \code{"fixed"},
or \code{"both"} (default \code{"adaptive"}).}

\item{method}{\code{"auto"}, \code{"AirHOLP"}, or \code{"AirOLS"}
(default \code{"auto"}).}
}
\value{
An object of class \code{"AirResult"}, a named list that may
contain the following elements (depending on \code{penalty_type}):
\describe{
\item{\code{order}, \code{order_adaptive}, \code{order_fixed}}{Integer
vector of feature indices sorted by absolute Air-HOLP or Air-OLS score,
from largest to smallest.}
\item{\code{rank}, \code{rank_adaptive}, \code{rank_fixed}}{Integer
vector of feature ranks matching \code{order}.}
\item{\code{Beta}, \code{Beta_adaptive}, \code{Beta_fixed}}{Numeric
vector of Air-HOLP or Air-OLS coefficient estimates.}
\item{\code{penalty}, \code{penalty_adaptive}, \code{penalty_fixed}}{
Final ridge penalty value(s) used.}
}
The helper \code{\link{summary.AirResult}} prints a concise summary.
}
\description{
\code{Air} is a high-level wrapper that applies either the
\code{\link{AirHOLP}} or \code{\link{AirOLS}} methods based on data
dimensions. It returns an \code{AirResult} object ready for inspection with
\code{\link{summary}}.
}
\details{
\itemize{
\item When \code{method = "auto"} (default), \code{\link{AirHOLP}} is used
if \eqn{p \ge n}; otherwise \code{\link{AirOLS}} is chosen.
\item \code{penalty_type} chooses whether the ridge penalty
is selected adaptively, fixed at the supplied value(s), or
both (returning two sets of ranks).
\item Air checks the validity of inputs and substitute by defaults
when invalid.
}
}
\examples{
## simple example (p > n  ->  AirHOLP)
set.seed(314)
X <- matrix(rnorm(100000), nrow = 200, ncol = 500)
y <- X[, 1] + X[, 2] + X[, 3] + X[, 4] + 3*rnorm(200)
result <- Air(X, y, penalty_type = "both")
summary(result)

## multiple fixed penalty values
result2 <- Air(X, y, penalty_type = "fixed", penalty = c(1, 100))
summary(result2)

}
\references{
Joudah, I., Muller, S., and Zhu, H. (2025).
"Air-HOLP: Adaptive Regularized Feature Screening for High-Dimensional Data."
\emph{Statistics and Computing}. \doi{10.1007/s11222-025-10599-6}
}
