% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dunn_function.R
\name{dunn}
\alias{dunn}
\title{Analysis: Post-hoc Dunn}
\usage{
dunn(trat, resp, method = "holm", alpha = 0.05, decreasing = TRUE)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Vector with response}

\item{method}{the p-value for multiple comparisons ("none", "bonferroni", "sidak", "holm", "hs", "hochberg", "bh", "by"). The default is no adjustment for multiple comparisons}

\item{alpha}{Significance level of the post-hoc (\emph{default} is 0.05)}

\item{decreasing}{Should the order of the letters be increasing or decreasing.}
}
\value{
Kruskal-wallis and dunn's post-hoc test returns
}
\description{
Perform Kruskal wallis and dunn post-hoc test
}
\examples{
library(AgroR)
data(pomegranate)

with(pomegranate, dunn(trat, WL))
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}
}
