% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripplot_function.R
\name{STRIPLOT}
\alias{STRIPLOT}
\title{Analysis: DBC experiments in strip-plot}
\usage{
STRIPLOT(
  f1,
  f2,
  block,
  response,
  norm = "sw",
  alpha.f = 0.05,
  transf = 1,
  textsize = 12,
  labelsize = 4,
  constant = 0
)
}
\arguments{
\item{f1}{Numeric or complex vector with plot levels}

\item{f2}{Numeric or complex vector with subplot levels}

\item{block}{Numeric or complex vector with blocks}

\item{response}{Numeric vector with responses}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{transf}{Applies data transformation (default is 1; for log consider 0)}

\item{textsize}{Font size (\emph{default} is 12)}

\item{labelsize}{Label size (\emph{default} is 4)}

\item{constant}{Add a constant for transformation (enter value)}
}
\value{
The table of analysis of variance, the test of normality of errors (Shapiro-Wilk, Lilliefors, Anderson-Darling, Cramer-von Mises, Pearson and Shapiro-Francia), the test of homogeneity of variances (Bartlett). The function also returns a standardized residual plot.
}
\description{
Analysis of an experiment conducted in a block randomized design in a strit-plot scheme using fixed effects analysis of variance.
}
\examples{

#===================================
# Example tomate
#===================================
# Obs. Consider that the "tomato" experiment is a block randomized design in strip-plot.
library(AgroR)
data(tomate)
with(tomate, STRIPLOT(parc, subp, bloco, resp))
}
\references{
Principles and procedures of statistics a biometrical approach Steel, Torry and Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

Practical Nonparametrics Statistics. W.J. Conover, 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.

Scott R.J., Knott M. 1974. A cluster analysis method for grouping mans in the analysis of variance. Biometrics, 30, 507-512.
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{DBC}
