% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSUBSUB_function.R
\name{PSUBSUBDBC}
\alias{PSUBSUBDBC}
\title{Analysis: DBC experiments in split-split-plot}
\usage{
PSUBSUBDBC(
  f1,
  f2,
  f3,
  block,
  response,
  alpha.f = 0.05,
  alpha.t = 0.05,
  dec = 3,
  mcomp = "tukey"
)
}
\arguments{
\item{f1}{Numeric or complex vector with plot levels}

\item{f2}{Numeric or complex vector with splitplot levels}

\item{f3}{Numeric or complex vector with splitsplitplot levels}

\item{block}{Numeric or complex vector with blocks}

\item{response}{Numeric vector with responses}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{dec}{Number of cells}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD and Duncan)}
}
\value{
Analysis of variance of fixed effects and multiple comparison test of Tukey, LSD or Duncan.
}
\description{
Analysis of an experiment conducted in a randomized block design in a split-split-plot scheme using analysis of variance of fixed effects.
}
\note{
The PSUBSUBDBC function does not present residual analysis, interaction breakdown, graphs and implementations of various multiple comparison or regression tests. The function only returns the analysis of variance and multiple comparison test of Tukey, LSD or Duncan.
}
\examples{
library(AgroR)
data(enxofre)
with(enxofre, PSUBSUBDBC(f1, f2, f3, bloco, resp))
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{DBC}
