% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATM_inference.R
\name{age_imputation}
\alias{age_imputation}
\title{imputing missing age if you can't find some of them
The function does two stage imputation:
i. if the individual has other age label -- use the mean, min, or max of other age labels for the missing ones.
ii. if the individual has no age label -- use the mean, min, max for all the diagnosis codes
iii. if there is no age info available for any of this code, we will impute it as the mean of all age codes in the data}
\usage{
age_imputation(rec_data_missing_age, method = "mean")
}
\arguments{
\item{rec_data_missing_age}{a data frame with missing age info}

\item{method}{use one of the three choices "mean", "min", "max"}
}
\value{
a data frame that is imputed and ready for wrapper_ATM
}
\description{
imputing missing age if you can't find some of them
The function does two stage imputation:
i. if the individual has other age label -- use the mean, min, or max of other age labels for the missing ones.
ii. if the individual has no age label -- use the mean, min, max for all the diagnosis codes
iii. if there is no age info available for any of this code, we will impute it as the mean of all age codes in the data
}
\examples{
rec_data_missing_age <- HES_age_example
 rec_data_missing_age$age_diag[1:10000] <- NA
 rec_data_imputed <- age_imputation(rec_data_missing_age, method= "mean")
 cor(rec_data_imputed$age_diag[1:10000], HES_age_example$age_diag[1:10000])
 rec_data_imputed <- age_imputation(rec_data_missing_age, method= "min")
 cor(rec_data_imputed$age_diag[1:10000], HES_age_example$age_diag[1:10000])
 rec_data_imputed <- age_imputation(rec_data_missing_age, method= "max")
 cor(rec_data_imputed$age_diag[1:10000], HES_age_example$age_diag[1:10000])
}
