% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{active_learning_pHMM}
\alias{active_learning_pHMM}
\title{Stream-Based Active Learning with a Partially Hidden Markov Model (pHMM)}
\usage{
active_learning_pHMM(
  y,
  true_x,
  T0,
  B = 0.1,
  weight_exploration = 0.5,
  lambda_MEWMA = 0.3,
  verbose = FALSE
)
}
\arguments{
\item{y}{A numeric matrix of dimension \eqn{T \times d}, where each row
corresponds to a \eqn{d}-dimensional observation at time \eqn{t}.}

\item{true_x}{Integer vector of true states of length \code{nrow(y)},
used to assess model predictions. The first \code{T0} values,
assumed to be from an in-control process, must be 1.}

\item{T0}{Integer. Number of initial observations assumed to be labeled as
in-control (state 1).}

\item{B}{Numeric between 0 and 1. Labeling budget, expressed as the maximum
fraction of observations (after the first \code{T0}) for which labels may
be acquired. Default is \code{0.1}.}

\item{weight_exploration}{Numeric between 0 and 1. Weight assigned to the
exploration criterion. The exploitation weight is computed as
\code{1 - weight_exploration}. Default is \code{0.5}.}

\item{lambda_MEWMA}{Numeric in (0,1). Smoothing parameter for the MEWMA
statistic used in the exploration criterion. Default is \code{0.3}.}

\item{verbose}{Logical. If \code{TRUE}, prints the current time index as the
algorithm progresses. Default is \code{FALSE}.}
}
\value{
A list with components:
\itemize{
  \item \code{decision}: character vector indicating the action taken at
        each time (\code{"label_exploitation"}, \code{"label_exploration"},
        or predicted state).
  \item \code{xlabeled}: updated state sequence including acquired labels.
  \item \code{xhat}: final predicted state sequence.
  \item \code{scores}: classification performance metrics (accuracy,
        precision, recall, F1, AUC) computed against the true states.
}
}
\description{
Implements the stream-based active learning strategy of Capezza, Lepore, and
Paynabar (2025) for process monitoring with partially observed states. At
each time step, the method fits a pHMM to the available data, and balances
between \emph{exploitation} (reducing predictive uncertainty) and
\emph{exploration} (detecting potential out-of-control shifts) to decide
whether to request the true label of the current observation. Labeling
requests are constrained by a user-defined budget.
}
\details{
The exploitation criterion is based on the entropy of the state sequence,
while the exploration criterion uses a multivariate exponentially weighted
moving average (MEWMA) statistic. The two criteria are combined with a
user-defined weighting, and labeling stops when the budget is exhausted
or at the end of the data stream.
}
\note{
This function is intended for simulation studies where the entire
observation sequence \code{y} and the corresponding true states \code{x}
are available in advance. The function uses these to evaluate the
active learning strategy under a given budgets. In real-time applications,
data and labels would arrive sequentially, and labels would only be obtained
if requested by the strategy.
}
\examples{
\donttest{
library(ActiveLearning4SPM)
set.seed(123)
dat <- simulate_stream(T0 = 50, TT = 100, T_min_IC = 20, T_max_IC = 30)
out <- active_learning_pHMM(y = dat$y,
                            true_x = dat$x,
                            T0 = 50,
                            B = 0.1)
table(out$decision)
out$scores$f1
}

}
\references{
Capezza, C., Lepore, A., & Paynabar, K. (2025).
  Stream-Based Active Learning for Process Monitoring.
  \emph{Technometrics}. <doi:10.1080/00401706.2025.2561744>.
}
