% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementary_pop.R
\name{elementary_pop}
\alias{elementary_pop}
\title{Create Elementary Schools population size}
\usage{
elementary_pop(df, dist_func = stats::rgamma, ...)
}
\arguments{
\item{df}{output data frame from catchment_sim function}

\item{dist_func}{distribution function to simulate school population, default is stats::rgamma}

\item{...}{additional arguments passed to the distribution function}
}
\value{
A data frame with the following columns:
\item{catchID}{Identifier for the catchment area}
\item{schoolID}{Unique identifier for each school}
\item{schoolPop}{Simulated population of the school}
\item{xStart}{Starting x-coordinate of the catchment area}
\item{xEnd}{Ending x-coordinate of the catchment area}
\item{yStart}{Starting y-coordinate of the catchment area}
\item{yEnd}{Ending y-coordinate of the catchment area}
}
\description{
Function to simulate elementary school size and assigns it to catchments.
The school population is simulated using a specified distribution function,
with gamma distribution as the default.
}
\examples{
# Simulate catchment areas
catch_df <- catchment_sim(16, 20, shape = 3.5, rate = 2.8)

# Simulate elementary schools using default gamma distribution
elementary_df1 <- elementary_pop(catch_df, shape = 5.1, rate = 0.015)

# Simulate elementary schools using normal distribution
elementary_df2 <- elementary_pop(catch_df, dist_func = stats::rnorm,
                                 mean = 300, sd = 50)

# Simulate elementary schools using Poisson distribution
elementary_df3 <- elementary_pop(catch_df, dist_func = stats::rpois,
                                 lambda = 250)
}
