% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATA_Forecast.R
\name{ATA.Forecast}
\alias{ATA.Forecast}
\title{Forecasting Method for The ATAforecasting}
\usage{
ATA.Forecast(
  object,
  h = NULL,
  out.sample = NULL,
  ci.level = 95,
  negative.forecast = TRUE,
  onestep = FALSE,
  print.out = TRUE
)
}
\arguments{
\item{object}{An \code{ata} object is required for forecast.}

\item{h}{Number of periods for forecasting.}

\item{out.sample}{A numeric vector or time series of class \code{ts} or \code{msts} for out-sample.}

\item{ci.level}{Confidence Interval levels for forecasting. Default value is 95.}

\item{negative.forecast}{Negative values are allowed for forecasting. Default value is TRUE. If FALSE, all negative values for forecasting are set to 0.}

\item{onestep}{Default is FALSE. if TRUE, the dynamic forecast strategy uses a one-step model multiple times (\code{h} forecast horizon) where the prediction for the prior time step is used as an input for making a prediction on the following time step.}

\item{print.out}{Default is TRUE. If FALSE, forecast summary of ATA Method is not shown.}
}
\value{
An object of class \code{ata} and forecast values.
}
\description{
\code{ATA.Forecast} is a generic function for forecasting of the ATA Method.
}
\examples{
trainATA <-  head(touristTR, 84)
ata_fit <- ATA(trainATA, parPHI = 1, seasonal.test = TRUE, seasonal.model = "decomp")
ata_fc <- ATA.Forecast(ata_fit, h=12)

}
\references{
#'\insertRef{yapar2017mses}{ATAforecasting}

#'\insertRef{yapar2018mhes}{ATAforecasting}

#'\insertRef{yapar2018mses}{ATAforecasting}

#'\insertRef{yapar2019ata}{ATAforecasting}
}
\seealso{
\code{forecast}, \code{stlplus}, \code{stR}, \code{\link[stats]{stl}}, \code{\link[stats]{decompose}},
\code{tbats}, \code{seasadj}.
}
\author{
Ali Sabri Taylan and Hanife Taylan Selamlar
}
\keyword{Ata}
\keyword{accuracy}
\keyword{forecast}
\keyword{msts}
\keyword{ts}
