% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansari.bradley.R
\name{ansari.bradley}
\alias{ansari.bradley}
\title{Perform Ansari-Bradley test}
\usage{
ansari.bradley(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  max.exact.cases = 25,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{25})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{ansari.bradley()} performs the Ansari-Bradley test and is used in chapter 6 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 6.12 from "Applied Nonparametric Statistical Methods" (5th edition)
ansari.bradley(ch6$typeA, ch6$typeB)

# Exercise 6.16 from "Applied Nonparametric Statistical Methods" (5th edition)
ansari.bradley(ch6$travel, ch6$politics)

}
