% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-convert.R
\name{conversion}
\alias{conversion}
\alias{toWide}
\alias{toLong}
\alias{toCompiled}
\alias{toRaw}
\alias{toTabular}
\title{Converting between formats}
\usage{
toWide(w)

toLong(w)

toCompiled(w)

toRaw(w)

toTabular(w)
}
\arguments{
\item{w}{An instance of an ANOFA object.}
}
\value{
a data frame in the requested format.
}
\description{
The functions \code{toWide()}, \code{toLong()}, \code{toCompiled()}
\code{toRaw()} and \code{toTabular()}
converts the data into various formats.
}
\details{
The classification of a set of $n$ participants can be
given using many formats. One basic format (called \code{wide} herein)
has $n$ lines, one per participants, and category names assigned
to each.
Another format (called \code{compiled} herein) is to have a list of all
the categories and the number of participants falling in each
cells. This last format is typically much more compact (if there
are 6 categories, the data are all contained in six lines).
However, we fail to see each individual contributing to the counts.
See the vignette DataFormatsForFrequencies for more.
A third possible format (called \code{raw} herein) put one column per
category and 1 is the observation matches this category, 0 otherwise.
This format results in $n$ lines, one participants, and as many
columns are there are categories.
Lastly, a fourth format (called \code{long} herein) as, on a line, the
factor name and the category assigned in that factor. If there are
$f$ factors and $n$ participants, the data are in $f*n$ lines.

See the vignette DataFormatsForFrequencies for more.
}
\examples{

# The minimalExample contains $n$ of 20 participants categorized according
# to two factors $f = 2$, namely `Intensity` (three levels) 
# and Pitch (two levels) for 6 possible cells.
minimalExample

# Lets incorporate the data in an anofa data structure
w <- anofa( Frequency ~ Intensity * Pitch, minimalExample )

# The data presented using various formats looks like
toWide(w)
# ... has 20 lines ($n$) and 2 columns ($f$)

toLong(w)
# ... has 40 lines ($n \times f$) and 3 columns (participant's `Id`, `Factor` name and `Level`)

toRaw(w)
# ... has 20 lines ($n$) and 5 columns ($2+3$)

toCompiled(w)
# ... has 6 lines ($2 \times 3$) and 3 columns ($f$ + 1)

toTabular(w)
# ... has one table with $2 \times 3$ cells. If there had been
# more than two factors, the additional factor(s) would be on distinct layers.


}
