% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness.R
\name{skewness}
\alias{skewness}
\alias{skewness.default}
\alias{skewness.matrix}
\alias{skewness.data.frame}
\title{Skewness of the Sample}
\usage{
skewness(x, na.rm = FALSE)

\method{skewness}{default}(x, na.rm = FALSE)

\method{skewness}{matrix}(x, na.rm = FALSE)

\method{skewness}{data.frame}(x, na.rm = FALSE)
}
\arguments{
\item{x}{A vector of values, a \link{matrix} or a \link{data.frame}.}

\item{na.rm}{A \link{logical} value indicating whether \code{NA} values should be stripped before the computation proceeds.}
}
\description{
Skewness is a measure of the asymmetry of the probability distribution of a real-valued random variable about its mean.

When negative ('left-skewed'): the left tail is longer; the mass of the distribution is concentrated on the right of a histogram. When positive ('right-skewed'): the right tail is longer; the mass of the distribution is concentrated on the left of a histogram. A normal distribution has a skewness of 0.
}
\examples{
skewness(runif(1000))
}
\seealso{
\code{\link[=kurtosis]{kurtosis()}}
}
