% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{Repeated}
\alias{Repeated}
\title{Repeated Crossfitting Procedure for AIPW}
\value{
\code{AIPW} object
}
\description{
An R6Class that allows repeated crossfitting procedure for an \link{AIPW} object
}
\details{
See examples for illustration.
}
\section{Constructor}{

\code{Repeated$new(aipw_obj = NULL)}
\subsection{Constructor Arguments}{

\tabular{lll}{
\strong{Argument}      \tab   \strong{Type}     \tab     \strong{Details} \cr
\code{aipw_obj}               \tab   \link{AIPW} object       \tab    an \link{AIPW} object \cr
}
}
}

\section{Public Methods}{

\tabular{lll}{
\strong{Methods}      \tab   \strong{Details}                                      \tab \strong{Link}     \cr
\code{repfit()}          \tab   Fit the data to the \link{AIPW} object \code{num_reps} times  \tab   \link{repfit.Repeated}  \cr
\code{summary_median()}      \tab   Summary (median) of estimates from the \code{repfit()}    \tab   \link{summary_median.Repeated}\cr
}
}

\section{Public Variables}{

\tabular{lll}{
\strong{Variable}     \tab   \strong{Generated by}      \tab     \strong{Return} \cr
\code{repeated_estimates}      \tab   \code{repfit()}                \tab     A data.frame of estiamtes form \code{num_reps} cross-fitting \cr
\code{repeated_results}      \tab   \code{summary_median()}                \tab     A list of sumarised estimates \cr
\code{result}         \tab   \code{summary_median()}                \tab     A data.frame of sumarised estimates \cr
}
\subsection{Public Variable Details}{

\describe{
\item{\code{repeated_estimates}}{Estimates from \code{num_reps} cross-fitting.}
\item{\code{result}}{Summarised estimates from ``repeated_estimates` using median methods.}
}
}
}

\examples{
library(SuperLearner)
library(ggplot2)

#create an object
aipw_sl <- AIPW$new(Y=rbinom(100,1,0.5), A=rbinom(100,1,0.5),
                    W.Q=rbinom(100,1,0.5), W.g=rbinom(100,1,0.5),
                    Q.SL.library="SL.mean",g.SL.library="SL.mean",
                    k_split=2,verbose=FALSE)

#create a repeated crossfitting object from the previous step
repeated_aipw_sl <- Repeated$new(aipw_sl)

#fit repetitively (stratified = TRUE will use stratified_fit() method in AIPW class)
repeated_aipw_sl$repfit(num_reps = 3, stratified = FALSE)

#summarise the results
repeated_aipw_sl$summary_median()

}
\references{
Zhong Y, Kennedy EH, Bodnar LM, Naimi AI (2021). AIPW: An R Package for Augmented Inverse Probability Weighted Estimation of Average Causal Effects. \emph{American Journal of Epidemiology}.

Robins JM, Rotnitzky A (1995). Semiparametric efficiency in multivariate regression models with missing data. \emph{Journal of the American Statistical Association}.

Chernozhukov V, Chetverikov V, Demirer M, et al (2018). Double/debiased machine learning for treatment and structural parameters. \emph{The Econometrics Journal}.

Kennedy EH, Sjolander A, Small DS (2015). Semiparametric causal inference in matched cohort studies. \emph{Biometrika}.
}
