% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{enrich}
\alias{enrich}
\title{Perform Adverse Event Enrichment Tests}
\usage{
enrich(
  data,
  dd.group,
  drug.case,
  drug.control = NULL,
  method = "aeks",
  n_perms = 1000,
  covar = NULL,
  p = 0,
  q.cut = 0.1,
  or.cut = 1.5,
  zero = FALSE,
  min_size = 5,
  min_AE = 10,
  cores = detectCores()
)
}
\arguments{
\item{data}{a data.frame. Two data types are allowed. Type I data consisting
data on the report level, having ID, Drug type and AE name as the first 3
columns with covariates(optional) followed. Type II data have drug type and
AE name as the first two columns, with the 3rd and 4th Columns giving the
numbers of successes(have AE) and failures(Do not have AE) respectively, then
followed by covariates. See example data for details.}

\item{dd.group}{a data.frame with AE name and Group name. This data.frame have
the group information for each individual AE.}

\item{drug.case}{a character string for the target drug of interest.}

\item{drug.control}{a character string for the reference drug. If NULL(default),
all other drugs combined are the reference.}

\item{method}{a character string specifying the method for the enrichment test.
It must take "aeks" (default) or "aefisher"; "aeks" is the rank-based
enrichment test, and "aefisher" is the Fisher enrichment test. See details
described in the paper (see reference section of this document).}

\item{n_perms}{an integer value specifying the number of permutations in
permutation test.}

\item{covar}{a character vector specifying the columns of covariates, default
NULL.}

\item{p}{a numerical value to control the weight of the step, can take any
value between 0 and 1. If 0(default), reduces to the standard Kolmogorov-Smirnov
statistics.}

\item{q.cut}{a numerical value specifying the significance cut for q value
of AEs in aefisher.}

\item{or.cut}{a numerical value specifying the significance cut for odds ratio
of AEs in aefisher.}

\item{zero}{logical, default FALSE.If TRUE, add zero indicator to enrichment score.}

\item{min_size}{the minimum size of group required for enrichment analysis.}

\item{min_AE}{the minimum number of cases required to start counting
for a specific AE.}

\item{cores}{the number of cores to use for parallel execution.}
}
\value{
A list containing 2 data.frames named \strong{Final_result} and \strong{AE_info}.

The \strong{Final_result} data.frame contains the following columns:
\describe{
\item{GROUP_NAME: }{AE group names}
\item{ES: }{enrichment score}
\item{p_value: }{p value of the enrichment test}
\item{GROUP_SIZE: }{number of AEs per group}
}

The \strong{AE_info} contains the following columns:
\describe{
\item{AE_NAME: }{AE names}
\item{OR: }{odds ratio for each individual AE}
\item{p_value: }{p value for AE-drug association}
\item{95Lower: }{lower bound of 95 percent confidence interval of odds ratio}
\item{95Lower: }{upper bound of 95 percent confidence interval of odds ratio}
\item{se(logOR): }{standard error of log odds ratio}
}
}
\description{
The enrich function is used to perform Adverse event (AE) enrichment analysis.
Unlike the continuous gene expression data, AE data are counts. Therefore,
AE data has many zeros and ties. We propose two enrichment tests. AEFisher is
a modified Fisher's exact test based on pre-selected significant AEs, while
AEKS is based on a modified Kolmogorov-Smirnov statistic.
}
\examples{

\donttest{
# AEKS

### Type I data: data on report level
# enrich(data = covid1, covar = c("SEX", "AGE"), p = 0, method = "aeks",
#        n_perms = 1000, drug.case = "COVID19", dd.group = group, cores = 2,
#        drug.control = "OTHER", min_size = 5, min_AE = 10, zero = FALSE)
      
## Type II data: aggregated data
# enrich(data = covid2, covar = c("SEX", "AGE"), p = 0, method = "aeks",
#        n_perms = 1000, drug.case = "DrugYes", dd.group = group, cores = 2,
#        drug.control = "DrugNo", min_size = 5, min_AE = 10)
      
# AEFISHER
## Type I data: data on report level
# enrich(data = covid1, covar = c("SEX", "AGE"), p = 0, method = "aefisher",
#        n_perms = 1000, drug.case = "COVID19", dd.group = group,
#        drug.control = "OTHER", min_size = 5, min_AE = 10, q.cut = 0.05, 
#        or.cut = 1.5, cores = 2)
      
## Type II data: aggregated data
# enrich(data = covid2, covar = c("SEX", "AGE"), p = 0, method = "aefisher",
#        n_perms = 1000, drug.case = "DrugYes", dd.group = group,
#        drug.control = "DrugNo", min_size = 5, min_AE = 10, cores = 2)
      }
}
\references{
Li, S. and Zhao, L. (2020). Adverse event enrichment tests using
VAERS. \doi{10.48550/arXiv.2007.02266}.

Subramanian, A.e.a. (2005). Gene set enrichment analysis: a knowledge-based
approach for interpreting genome-wide expression profiles. Proc Natl Acad
Sci U S A. Proceedings of the National Academy of Sciences. 102. 15545-15550.

Tian, Lu & Greenberg, Steven & Kong, Sek Won & Altschuler, Josiah & Kohane, Isaac & Park,
Peter. (2005). Discovering statistically significant pathways in expression profiling studies.
Proceedings of the National Academy of Sciences of the United States of America.
102. 13544-9. 10.1073/pnas.0506577102.
}
