% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\name{ss_sum_mh_ple}
\alias{ss_sum_mh_ple}
\title{Compute sum for MH-PLE scores}
\usage{
ss_sum_mh_ple(
  data,
  name,
  fork_vars,
  fork_val = "1",
  vars,
  max_na = NULL,
  exclude = NULL,
  events = NULL,
  combine = TRUE,
  no_na = FALSE
)
}
\arguments{
\item{data}{Data frame containing columns to summarize}

\item{name}{String specifying name for summary score column}

\item{fork_vars}{Character vector of columns used as logical conditions}

\item{fork_val}{String indicating value in fork_vars for valid responses}

\item{vars}{Character vector of columns to summarize}

\item{max_na}{Integer for maximum allowed missing values}

\item{exclude}{Character vector of values to exclude}

\item{events}{Character vector of events to compute scores for}

\item{combine}{Logical; if TRUE, append score to input data}

\item{no_na}{Logical; if TRUE, return NA when any value is missing}
}
\value{
Data frame with summary score column
}
\description{
Calculates sum scores for variables with forking logic, where variables may
only be applicable based on certain conditions. Missing values and exclusions
are handled based on the forking variable values.
}
\examples{
data <- tibble::tribble(
  ~session_id, ~a, ~b, ~c, ~a__severe, ~b__severe, ~c__severe,
  "ses-00A", "1", "1", "1", "1", NA, NA,
  "ses-01A", "1", "1", "1", "2", "777", "2"
)

data |>
  ss_sum_mh_ple(
    name = "sum",
    fork_vars = c("a", "b", "c"),
    vars = paste0(c("a", "b", "c"), "__severe"),
    max_na = 1,
    exclude = c("777", "999")
  )
}
\keyword{internal}
