% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_data.R
\name{filter_data}
\alias{filter_data}
\title{Filtering DNA methylation 450k non_specific probes}
\usage{
filter_data(x)
}
\arguments{
\item{x}{The normalised beta values in a data matrix format, where conditions are arranged in columns and cg probes are arranged in rows.}
}
\description{
This function filters the reported nonspecific probes, and also filters probes that interrogate SNPs of minor allele frequency (MAF) > 0.1. A list of nonspecific probes was obtained from Chen et al (2013) supplementary files.
}
\examples{
data(test_data)
data(nonspecific_probes)
test_data_filtered <- filter_data(test_data)

}
\references{
Chen YA, Lemire M, Choufani S, et al. Discovery of cross-reactive probes and polymorphic CpGs in the Illumina Infinium HumanMethylation450 microarray. Epigenetics 2013;8:203-9.
}

