% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aat_stimulus_rest.R
\name{aat_stimulus_rest}
\alias{aat_stimulus_rest}
\alias{plot.aat_stimulus_rest}
\title{Compute stimulus-rest correlations of double-difference scores
This function provides a statistic that can give an indication of how deviant
the responses to specific stimuli are, in comparison to the rest of the stimulus set.
The algorithm computes stimulus-rest correlations of stimulus-specific double-difference scores.
It takes single-difference approach-avoidance scores for each stimulus, and computes
every possible subtraction between individual stimuli from both stimulus categories.
It then computes correlations between every such subtraction of stimuli on one hand, and
the mean double difference score of all other stimuli. Stimulus-rest correlations are then
computed by averaging every such subtraction-rest correlation involving a specific stimulus.}
\usage{
aat_stimulus_rest(
  ds,
  subjvar,
  stimvar,
  pullvar,
  targetvar,
  rtvar,
  method = c("pearson", "spearman", "kendall")
)

\method{plot}{aat_stimulus_rest}(x, ...)
}
\arguments{
\item{ds}{a \code{data.frame}}

\item{subjvar}{the label of the participant identifier variable}

\item{stimvar}{the label of the stimulus identifier variable}

\item{pullvar}{the label of the movement direction identifier variable}

\item{targetvar}{the label of the stimulus category identifier variable}

\item{rtvar}{the label of the reaction time variable}

\item{method}{Optional, the correlation method to be used (pearson, spearman, kendall)}

\item{x}{an \code{aat_stimulus_rest} object}

\item{...}{Ignored.}
}
\value{
Returns a \code{aat_stimulus_rest} object containing statistics for each stimulus.
Stats include the average stimulus-rest correlation (mcor); the standard deviation of
dyad-rest correlations for this stimulus (sdcor);
the number of valid correlations involved in these statistic (n);
the average percentile of dyad-rest correlations involving the stimulus within
the distribution of all other dyad-rest correlations (restpercentile);
as well as z-scores (zpercentile) and p-values for this percentile (pval).
}
\description{
Compute stimulus-rest correlations of double-difference scores
This function provides a statistic that can give an indication of how deviant
the responses to specific stimuli are, in comparison to the rest of the stimulus set.
The algorithm computes stimulus-rest correlations of stimulus-specific double-difference scores.
It takes single-difference approach-avoidance scores for each stimulus, and computes
every possible subtraction between individual stimuli from both stimulus categories.
It then computes correlations between every such subtraction of stimuli on one hand, and
the mean double difference score of all other stimuli. Stimulus-rest correlations are then
computed by averaging every such subtraction-rest correlation involving a specific stimulus.
}
\examples{

ds<-aat_simulate()
stimrest<-aat_stimulus_rest(ds,subjvar="subj",stimvar="stim",pullvar="is_pull",
                     targetvar="is_target",rtvar="rt")
plot(stimrest)
print(stimrest)
}
