% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.immunr_ov_matrix}
\alias{vis.immunr_ov_matrix}
\alias{vis.immunr_gu_matrix}
\title{Repertoire overlap and gene usage visualisations}
\usage{
\method{vis}{immunr_ov_matrix}(.data, .plot = c("heatmap", "heatmap2", "circos"), ...)
}
\arguments{
\item{.data}{Output from \link{repOverlap} or \link{geneUsageAnalysis}.}

\item{.plot}{A string specifying the plot type:

- "heatmap" for heatmaps using \link{vis_heatmap};

- "heatmap2" for heatmaps using \link{vis_heatmap2};

- "circos" for circos plots using \link{vis_circos};}

\item{...}{Other arguments are passed through to the underlying plotting function:

- "heatmap" - passes arguments to \link{vis_heatmap};

- "heatmap2" - passes arguments to \link{vis_heatmap2} and \link{heatmap} from the "pheatmap" package;

- "circos" - passes arguments to \link{vis_circos} and \link{chordDiagram} from the "circlize" package;}
}
\value{
A ggplot2, pheatmap or circlize object.
}
\description{
Visualise matrices with overlap values or gene usage distances among samples.
For details see links below.
}
\examples{
data(immdata)
ov <- repOverlap(immdata$data)
vis(ov)
vis(ov, "heatmap")
vis(ov, "heatmap2")
vis(ov, "circos")

}
\concept{overlap}
