test_that("callRelatedness errors", {
  false_example1 <- counts_example %>% dplyr::rename(bob = pair)
  expect_error(callRelatedness(false_example1))
  expect_error(callRelatedness(counts_example, class_prior = -1))
  expect_error(callRelatedness(counts_example, class_prior = 1.1))
  expect_error(callRelatedness(counts_example, class_prior = c(0.1, 0.1)))
  expect_error(callRelatedness(counts_example, average_relatedness = 1.1))
  expect_error(callRelatedness(counts_example, median_co = -1))
  expect_error(callRelatedness(counts_example, filter_n = -1))
  tmp <- callRelatedness(counts_example)
  expect_equal(nrow(tmp), 15)
  expect_equal(ncol(tmp), 12)
  expect_equal(tmp$pmr[1], 0.2042, tolerance = 0.001)
})
