% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\docType{class}
\name{zarr_node}
\alias{zarr_node}
\title{Zarr Hierarchy node}
\description{
This class implements a Zarr node. The node is an element in the
hierarchy of the Zarr object. As per the Zarr specification, the node is
either a group or an array. Thus, this class is the ancestor of the
\link{zarr_group} and \link{zarr_array} classes. This class manages common features
such as names, key, prefixes and paths, as well as the hierarchy between
nodes and the \link{zarr_store} for persistent storage.

This class should never have to be instantiated or accessed directly.
Instead, use instances of \code{zarr_group} or \code{zarr_array}. Function arguments
are largely not checked, the group and array instances should do so prior
to calling methods here. The big exception is checking the validity of node
names.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{(read-only) The name of the node.}

\item{\code{parent}}{(read-only) The parent of the node. For a root node this
returns \code{NULL}, otherwise this \code{zarr_group} or \code{zarr_array} instance.}

\item{\code{store}}{(read-only) The store of the node.}

\item{\code{path}}{(read-only) The path of this node, relative to the root node
of the hierarchy.}

\item{\code{prefix}}{(read-only) The prefix of this node, relative to the root
node of the hierarchy.}

\item{\code{metadata}}{(read-only) The metadata document of this node, a list.}

\item{\code{attributes}}{(read-only) Retrieve the list of attributes of this
object. Attributes can be added or modified with the \code{set_attribute()}
method or removed with the \code{delete_attributes()} method.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zarr_node-new}{\code{zarr_node$new()}}
\item \href{#method-zarr_node-print_attributes}{\code{zarr_node$print_attributes()}}
\item \href{#method-zarr_node-set_attribute}{\code{zarr_node$set_attribute()}}
\item \href{#method-zarr_node-delete_attributes}{\code{zarr_node$delete_attributes()}}
\item \href{#method-zarr_node-save}{\code{zarr_node$save()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_node-new"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_node-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new node in a Zarr hierarchy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_node$new(name, metadata, parent, store)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the node.}

\item{\code{metadata}}{List with the metadata of the node.}

\item{\code{parent}}{The parent node of this new node. Must be omitted when
initializing a root node.}

\item{\code{store}}{The store to persist data in. Ignored if a \code{parent} is
specified.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_node-print_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_node-print_attributes}{}}}
\subsection{Method \code{print_attributes()}}{
Print the metadata "attributes" to the console. Usually
called by the \link{zarr_group} and \link{zarr_array} \code{print()} methods.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_node$print_attributes(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments passed to embedded functions. Of particular interest
is \code{width = .} to specify the maximum width of the columns.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_node-set_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_node-set_attribute}{}}}
\subsection{Method \code{set_attribute()}}{
Add an attribute to the metadata of the object. If an
attribute \code{name} already exists, it will be overwritten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_node$set_attribute(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the attribute. The name must begin with a letter
and be composed of letters, digits, and underscores, with a maximum
length of 255 characters.}

\item{\code{value}}{The value of the attribute. This can be of any supported
type, including a vector or list of values. In general, an attribute
should be a character value, a numeric value, a logical value, or a
short vector or list of any of these.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_node-delete_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_node-delete_attributes}{}}}
\subsection{Method \code{delete_attributes()}}{
Delete attributes. If an attribute in \code{name} is not present
this method simply returns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_node$delete_attributes(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Vector of names of the attributes to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_node-save"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_node-save}{}}}
\subsection{Method \code{save()}}{
Persist any edits to the group or array to the store.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_node$save()}\if{html}{\out{</div>}}
}

}
}
