% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yields.R
\name{ypr_yields}
\alias{ypr_yields}
\title{Yields}
\usage{
ypr_yields(
  object,
  pi = seq(0, 1, length.out = 100),
  Ly = 0,
  harvest = TRUE,
  biomass = FALSE
)
}
\arguments{
\item{object}{The population or populations.}

\item{pi}{A vector of probabilities of capture to calculate the yield for.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the
yield (cm).}

\item{harvest}{A flag specifying whether to calculate the yield for harvested
fish or captures.}

\item{biomass}{A flag specifying whether to calculate the yield in terms of
the biomass versus number of individuals.}
}
\value{
A numeric vector of the yields.
}
\description{
Calculates the yield(s) for a population based on one or more capture rates.
}
\examples{
pi <- seq(0, 1, length.out = 30)
plot(pi, ypr_yields(ypr_population(), pi), type = "l")
}
\seealso{
Other yield: 
\code{\link{ypr_plot_yield}()},
\code{\link{ypr_tabulate_yield}()},
\code{\link{ypr_yield}()}

Other calculate: 
\code{\link{ypr_age_at_length}()},
\code{\link{ypr_exploitation}()},
\code{\link{ypr_length_at_age}()},
\code{\link{ypr_optimize}()},
\code{\link{ypr_yield}()}
}
\concept{calculate}
\concept{yield}
