% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{treeProbability}
\alias{treeProbability}
\title{The (path) probability of generating \code{tree} by grammar \code{G}.}
\usage{
treeProbability(tree, G)
}
\arguments{
\item{tree}{Derivation tree.}

\item{G}{A context-free grammar.}
}
\value{
Real. The probability of generating \code{tree} 
              by grammar \code{G}.
}
\description{
\code{treeProbability()} returns the path
             probability of generating the derivation tree \code{tree} 
             by the context-free grammar \code{G}. 
             The probability is exact, if the grammar is not ambiguous and
             if the grammar does not contain redundant rules.
}
\examples{
g<-compileBNF(booleanGrammar())
a<-randomDerivationTree(g$Start, g)
decodeTree(a, g$ST) 
treeProbability(tree=a, G=g)

}
\seealso{
Other Measures of Tree Attributes: 
\code{\link{treeLeaves}()},
\code{\link{treeListDepth}()},
\code{\link{treeNodes}()},
\code{\link{treeSize}()}
}
\concept{Measures of Tree Attributes}
