% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyn_matrix.R
\name{dyn_matrix}
\alias{dyn_matrix}
\title{Get matrix of apparent survival}
\usage{
dyn_matrix(animal_id, capture_date, start_dates, end_dates)
}
\arguments{
\item{animal_id}{A column in the dataframe of all samples that stores
individual animal identifier code.}

\item{capture_date}{A column in the dataframe of all samples that stores
the date of sample collection. Must be in \code{Date} format.}

\item{start_dates}{Vector of dates in \code{Date} format that define the
start of each season.}

\item{end_dates}{Vector of dates in \code{Date} format that define the
end of each season.}
}
\value{
A matrix with 1 + no. seasons rows and columns.
\itemize{
\item diagonal: number of new captures in each session,
\item above diagonal: number of recaptures from season x to season y,
\item below diagonal: number of animals from season y that skipped season x.
}

Season x is defined in first row, season y in first column.
Column \verb{Tot. Capts} gives all detected individuals in season y.
Row \verb{Tot. Skipped} gives all individuals skipped in season x but detected
later.
}
\description{
Creates a matrix that shows number of captured animals
between multiple seasons.
}
\examples{
# Define start and end dates for sampling seasons.
seasons <- data.frame(
  start = c(
    as.Date("2017-01-01"),
    as.Date("2018-01-01"),
    as.Date("2019-01-01")
  ),
  end = c(
    as.Date("2017-12-31"),
    as.Date("2018-12-31"),
    as.Date("2019-12-31")
  )
)

# Create a dynamics matrix for animal captures.
dyn_matrix(
  animal_id = wolf_samples$AnimalRef,
  capture_date = wolf_samples$Date,
  start_dates = seasons$start,
  end_dates = seasons$end
)


}
