% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{as.matrix.word2vec}
\alias{as.matrix.word2vec}
\title{Get the word vectors of a word2vec model}
\usage{
\method{as.matrix}{word2vec}(x, encoding = "UTF-8", ...)
}
\arguments{
\item{x}{a word2vec model as returned by \code{\link{word2vec}} or \code{\link{read.word2vec}}}

\item{encoding}{set the encoding of the row names to the specified encoding. Defaults to 'UTF-8'.}

\item{...}{not used}
}
\value{
a matrix with the word vectors where the rownames are the words from the model vocabulary
}
\description{
Get the word vectors of a word2vec model as a dense matrix.
}
\examples{
path  <- system.file(package = "word2vec", "models", "example.bin")
model <- read.word2vec(path)

embedding <- as.matrix(model)
}
\seealso{
\code{\link{word2vec}}, \code{\link{read.word2vec}}
}
