% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_coerce_buttons_mixed}
\alias{whapi_coerce_buttons_mixed}
\title{Coerce and validate MIXED buttons (url / call / copy) for Whapi}
\usage{
whapi_coerce_buttons_mixed(buttons, verbose = TRUE)
}
\arguments{
\item{buttons}{A \code{data.frame}/\code{tibble} (one row per button) or a list of
named lists. \code{title} is required (or via alias), \code{id} is auto-generated
when missing by \code{\link[=whapi_coerce_buttons_base]{whapi_coerce_buttons_base()}}. Each button \strong{must provide}
a valid \code{type} among \verb{\{"url","call","copy"\}}.}

\item{verbose}{Logical (default \code{TRUE}). If \code{TRUE}, prints progress messages
via \pkg{cli}.}
}
\value{
A list-of-lists of buttons, each validated to contain the fields required
for its \code{type}.
}
\description{
Internal helper that prepares \strong{mixed action} buttons for Whapi interactive
messages. It first normalizes input via \code{\link[=whapi_coerce_buttons_base]{whapi_coerce_buttons_base()}} (accepts
\code{data.frame}/\code{tibble} or \code{list}, maps aliases to \code{title}, auto-creates \code{id}
with slug + uniqueness) and then validates each button according to its
declared \code{type}:
\itemize{
\item \code{url}  -> requires fields: \code{title}, \code{id}, \code{url}
\item \code{call} -> requires fields: \code{title}, \code{id}, \code{phone_number}
\item \code{copy} -> requires fields: \code{title}, \code{id}, \code{copy_code}
}

Enforces WhatsApp constraints: \strong{1 to 3} buttons per message.
}
\examples{
# Example with a tibble:
 tibble::tribble(
   ~title,        ~type, ~url, ~phone_number,
   "Website",     "url", "https://example.com", NA,
   "Call Support","call", NA, "5581999999999"
 ) |>
   whapi_coerce_buttons_base() |>
   whapi_coerce_buttons_mixed()

# Example with a list:
 whapi_coerce_buttons_mixed(list(
   list(type="url",  title="Website", url="https://example.com"),
   list(type="call", title="Call us", phone_number="5581999999999"),
   list(type="copy", title="Copy OTP", copy_code="123456")
 ))

}
\seealso{
\code{\link[=whapi_coerce_buttons_base]{whapi_coerce_buttons_base()}} for normalization;
\code{\link[=whapi_coerce_buttons_quick]{whapi_coerce_buttons_quick()}} for quick-reply buttons.
}
