% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trellis_vismi_converge.R
\name{trellis_vismi_converge}
\alias{trellis_vismi_converge}
\title{Trelliscope Visualisation of Convergence Diagnostics}
\usage{
trellis_vismi_converge(
  obj,
  tick_vals = NULL,
  color_pal = NULL,
  title = "auto",
  subtitle = "auto",
  nrow = 2,
  ncol = 4,
  path = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{obj}{An object of class 'mixgb' or 'mids' containing intermediate imputed result for each iteration.}

\item{tick_vals}{A numeric vector specifying the tick values for the x-axis (iterations). If NULL, default tick values will be used.}

\item{color_pal}{A vector of colors to use for the imputation lines. If NULL, default colors will be used.}

\item{title}{A string specifying the title of the plot. If NULL, no title is shown. If "auto", a title will be generated based on the input. Default is "auto".}

\item{subtitle}{A string specifying the subtitle of the plot. If NULL, no subtitle is shown. If "auto", a title will be generated based on the input. Default is "auto".}

\item{nrow}{Number of rows in the Trelliscope display. Default is 2.}

\item{ncol}{Number of columns in the Trelliscope display. Default is 4.}

\item{path}{Optional path to save the Trelliscope display. If NULL, the display will not be saved to disk.}

\item{verbose}{A logical value indicating whether to print extra information. Default is FALSE.}

\item{...}{Additional arguments to customize the Trelliscope display.}
}
\value{
A Trelliscope display object visualising convergence diagnostics for all variables.
}
\description{
Generates a Trelliscope display for convergence diagnostics across all variables.
}
\examples{
library(mixgb)
set.seed(2026)
mixgb_obj <- mixgb(data = nhanes3, m = 3, maxit = 4, pmm.type = "auto", save.models = TRUE)
trellis_vismi_converge(obj = mixgb_obj)
}
