% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatcomp.R
\name{heatcomp}
\alias{heatcomp}
\title{Components Heat Plot}
\usage{
heatcomp(
  model,
  sep = "+",
  median = TRUE,
  random = TRUE,
  z_value = FALSE,
  freq = TRUE,
  legend_name = NULL
)
}
\arguments{
\item{model}{An object of class \code{\link[netmeta]{netmeta}}.}

\item{sep}{A single character that defines the separator between interventions components.}

\item{median}{\code{logical}. If \code{TRUE} the median is used instead of the mean as a summary measure.}

\item{random}{\code{logical}. If \code{TRUE} the random-effects NMA model is used instead of the fixed-effect NMA model.}

\item{z_value}{\code{logical}. If \code{TRUE} z-values are used instead of interventions effects.}

\item{freq}{\code{logical}. If \code{TRUE} the frequency of component combinations are printed.}

\item{legend_name}{A single character that specifies the title of the legend.}
}
\value{
An object of class \code{ggplot}.
}
\description{
The function creates a heat plot based on the two-by-two component combinations, obtained from the
network meta-analysis (NMA) model.
}
\details{
Diagonal elements refer to components, while off-diagonal to components' combinations. Each element summarizes by default
the NMA relative effects (\code{z_value = FALSE}) of the interventions that includes the corresponding
component combination. Combinations that were not observed in the NMA model, are denoted by the letter "X".
Frequency of component combinations observed in the NMA is printed by default (\code{freq = TRUE}). As a summary measure,
the median is used by default (\code{median = TRUE}). The magnitude of each relative effect is reflected by the color's intensity.
Estimates close to zero are denoted by white color, and indicates a small magnitude of the corresponding component combination, while
deep green and red colors indicate a large magnitude of the corresponding component combination.
Outcomes nature (beneficial or harmful) is defined in the \code{netmeta} model.

The function can be also adjusted to include z-scores by setting the argument \code{z_value = TRUE}.
Z-scores quantify the strength of statistical evidence. Thus, dark green (or red) indicates strong statistical evidence that
the corresponding component (or combination of components) performs better (or worse) than the reference intervention.
}
\note{
In the case where the NMA relative effects are used, the uncertainty of the NMA estimates are reflected by the size of the grey boxes.
The bigger the box, the more precise the estimate.

By setting \code{median = FALSE}, the mean is used instead of the median as a summary measure.

The function can be applied only in network meta-analysis models that contain multi-component interventions.
}
\examples{
data(nmaMACE)
heatcomp(model = nmaMACE)

}
