% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvi_singlerun.R
\name{run_single}
\alias{run_single}
\title{CVI implementation for one set of initial parameters}
\usage{
run_single(
  config,
  X,
  N,
  D,
  T0,
  prior_shape_alpha,
  prior_rate_alpha,
  post_shape_alpha,
  post_rate_alpha,
  prior_mean_eta,
  post_mean_eta,
  fixed_variance,
  covariance_type,
  cluster_specific_covariance,
  variance_prior_type,
  maxit,
  varargs
)
}
\arguments{
\item{config}{List of inputs that are generated if not user-provided}

\item{X}{the data matrix}

\item{N}{samples of X}

\item{D}{dimensions of X}

\item{T0}{variational clusters}

\item{prior_shape_alpha}{shape parameter of Gamma prior for the DP
concentration parameter alpha. Default is 0.001}

\item{prior_rate_alpha}{rate parameter of Gamma prior for the DP
concentration parameter alpha. Default is 0.001}

\item{post_shape_alpha}{initial value for posterior update of shape parameter
for alpha. Default is 0.001}

\item{post_rate_alpha}{initial value for posterior update of ratee parameter
for alpha. Default is 0.001}

\item{prior_mean_eta}{mean vector of MVN prior for the DP mean parameters.
Default is zero vector}

\item{post_mean_eta}{initial value of posterior update for the DP mean
parameter}

\item{fixed_variance}{covariance matrix of the data is considered known (fixed)
or unknown.}

\item{covariance_type}{covariance matrix is considered diagonal or full.}

\item{cluster_specific_covariance}{covariance matrix is specific to a cluster
allocation or it is same over all cluster choices.}

\item{variance_prior_type}{For unknown and full covariance matrix, choice of
matrix prior is either Inverse-Wishart ('IW') or Cholesky-decomposed
('decomposed'). For unknown, full and cluster-specific covariance matrix,
choice of matrix prior is either Inverse-Wishart ('IW'), element-wise Gamma
and Laplace distributed ('sparse') or element-wise Gamma and Normal
distributed ('off-diagonal normal')}

\item{maxit}{Maximum number of iterations for variational updates}

\item{varargs}{List of case specific parameters}
}
\value{
a \code{list} with the following elements:
\itemize{
\item \code{alpha}: posterior DP concentration parameter
\item \verb{Cluster number}: number of clusters from posterior probability allocation matrix
\item \verb{Cluster Proportion}: cluster proportions from posterior probability allocation matrix
\item \verb{log Probability matrix}: log of posterior probability allocation matrix
\item \code{ELBO}: Optimisation of the ELBO function
\item \code{Iterations}: Number of iterations required for convergence
}
}
\description{
CVI implementation for one set of initial parameters
}
