% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pc_diffs.R
\name{plot_pc_diffs}
\alias{plot_pc_diffs}
\title{Plot principal component directions}
\usage{
plot_pc_diffs(
  fpcs,
  fdasrvf,
  fpca_method,
  times = NULL,
  digits = 0,
  alpha = 1,
  alpha_fill = 0.5,
  nrow = 1,
  linesizes = NULL,
  mean_linesize = NULL,
  linetype = TRUE,
  freey = FALSE
)
}
\arguments{
\item{fpcs}{Vector of numbers identifying the PCs to include in the plot}

\item{fdasrvf}{Object output from jointFPCA, horizFPCA, or vertFPCA}

\item{fpca_method}{Character string specifying the type of elastic fPCA method to use ('jfpca', 'hfpca', or 'vfpca')}

\item{times}{Optional vector of times (if not included, times will be represented on the interval from 0 to 1)}

\item{digits}{Number of digits to print in the title for the proportion of variability explained by a PC}

\item{alpha}{Vector of alpha values associated with lines in plot (length must match number of lines in plot)}

\item{alpha_fill}{Value of alpha to use with the fill color in the ribbons (length of 1).}

\item{nrow}{Number of rows to use when creating a grid of plots}

\item{linesizes}{Vector of line widths associated with lines in plot (length must match number of lines in plot)}

\item{mean_linesize}{Value of width to use with the horizontal line with an intercept of 0.}

\item{linetype}{Vector of line types (e.g., "solid" or "dashed") associated with lines in plot (length must match number of lines in plot)}

\item{freey}{Indicator for whether y-axis should be freed across facets}
}
\value{
ggplot2 plot of specified differences beteen principal component directions and the Karcher mean
}
\description{
Function for plotting the functional PC directions
}
\examples{
# Load packages
library(dplyr)
library(tidyr)

# Select a subset of functions from shifted peaks data
sub_ids <-
  shifted_peaks$data |>
  select(data, group, id) |>
  distinct() |>
  group_by(data, group) |>
  slice(1:4) |>
  ungroup()

# Create a smaller version of shifted data
shifted_peaks_sub <-
  shifted_peaks$data |>
  filter(id \%in\% sub_ids$id)

# Extract times
shifted_peaks_times = unique(shifted_peaks_sub$t)

# Convert training data to matrix
shifted_peaks_train_matrix <-
  shifted_peaks_sub |>
  filter(data == "Training") |>
  select(-t) |>
  mutate(index = paste0("t", index)) |>
  pivot_wider(names_from = index, values_from = y) |>
  select(-data, -id, -group) |>
  as.matrix() |>
  t()

# Obtain veesa pipeline training data
veesa_train <-
  prep_training_data(
    f = shifted_peaks_train_matrix,
    time = shifted_peaks_times,
    fpca_method = "jfpca"
  )

# Plot principal directions of PC1
plot_pc_diffs(
  fpcs = 1,
  fdasrvf = veesa_train$fpca_res,
  fpca_method = "jfpca",
  times = -shifted_peaks_times,
  linesizes = rep(0.75,5),
  mean_linesize = 0.5,
  alpha = 0.9,
  alpha_fill = 0.25
 )
}
