% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line_integral_vector2d.R
\name{line_integral_vector2d}
\alias{line_integral_vector2d}
\title{2D line integral of a vector field with visualization}
\usage{
line_integral_vector2d(
  field,
  r,
  a,
  b,
  plot = TRUE,
  n_curve = 600,
  grid_n = 15,
  padding = 0.15,
  h = NULL,
  method = c("adaptive", "simpson"),
  n_simpson = 1000,
  arrow_scale = 0.08,
  normalize_bias = 1,
  field_color = "rgba(0,0,0,0.55)",
  field_width = 1.8,
  traj_palette = "RdBu",
  traj_width = 5,
  show_markers = FALSE,
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white")
)
}
\arguments{
\item{field}{Vector field in the plane. A function \code{function(x, y)} that
returns a numeric vector of length 2 \code{c(Fx, Fy)}.}

\item{r}{Parametric curve in the plane. A function \code{function(t)} that
returns a numeric vector of length 2 \code{c(x, y)}.}

\item{a}{Numeric scalar. Left endpoint of the parameter interval.}

\item{b}{Numeric scalar. Right endpoint of the parameter interval.
Must satisfy \code{b > a}.}

\item{plot}{Logical. If \code{TRUE}, an interactive \pkg{plotly} figure is
created with the field and the curve.}

\item{n_curve}{Integer. Number of parameter values used to sample the curve.}

\item{grid_n}{Integer. Number of grid points per axis used to draw the
vector field arrows.}

\item{padding}{Numeric scalar. Relative margin added around the bounding
box of the curve when building the field grid.}

\item{h}{Numeric scalar or \code{NULL}. Step size used in the finite
difference approximation of the derivative of the curve. If \code{NULL},
a small step is chosen automatically, based on the length of the interval
\code{b - a}.}

\item{method}{Character string. Integration method for the line integral.
One of \code{"adaptive"} (uses \code{stats::integrate}) or
\code{"simpson"} (composite Simpson rule).}

\item{n_simpson}{Integer. Number of subintervals used when
\code{method = "simpson"}. If it is odd, it is increased by one
internally.}

\item{arrow_scale}{Numeric scalar. Controls the overall length of the field
arrows as a fraction of the plot span.}

\item{normalize_bias}{Numeric scalar. Saturation parameter used to avoid
extremely long arrows for large field magnitudes.}

\item{field_color}{Character string. Color used for the field arrows.}

\item{field_width}{Numeric scalar. Line width for the field arrows.}

\item{traj_palette}{Color scale used to represent the power along the
trajectory. Passed to \pkg{plotly} as a colorscale name.}

\item{traj_width}{Numeric scalar. Line width for the trajectory.}

\item{show_markers}{Logical. If \code{TRUE}, markers are drawn along the
trajectory in addition to the line.}

\item{scene}{List with \pkg{plotly} scene options (axis titles, aspect
mode, etc.) passed to \code{plotly::layout()}.}

\item{bg}{List with background colors for \pkg{plotly}, with components
\code{paper} and \code{plot}.}
}
\value{
A list with components:
\itemize{
\item \code{value}: numeric value of the line integral.
\item \code{samples}: data frame with sampled points, velocities
and power along the trajectory.
\item \code{fig}: \pkg{plotly} object when \code{plot = TRUE},
otherwise \code{NULL}.
}
}
\description{
This function computes a numerical approximation of the line integral
of a planar vector field along a parametric curve r(t) on the interval
from a to b. The derivative of the curve is approximated by finite
differences and the integral is evaluated either by an adaptive numerical
integrator or by a composite Simpson rule.
}
\details{
Optionally, the function can build an interactive \pkg{plotly} figure that
shows a grid of arrows for the vector field and the curve colored by the
local power field(r(t)) * r'(t).
}
\examples{
# Simple example:
# field(x, y) = (y, -x), r(t) = (cos t, sin t), t in [0, 2*pi]
line_integral_vector2d(
  field = function(x, y) c(y, -x),
  r = function(t) c(cos(t), sin(t)),
  a = 0, b = 2*pi, plot = FALSE
)

}
