% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binormal3d.R
\name{binormal3d}
\alias{binormal3d}
\title{Binormal vectors along a 3D parametric curve}
\usage{
binormal3d(
  X,
  Y,
  Z,
  a,
  b,
  t_points,
  h = 1e-04,
  plot = FALSE,
  n_samples = 400,
  vec_scale = NULL,
  vec_factor = 1,
  curve_line = list(color = "blue", width = 2, dash = "solid"),
  B_line = list(color = "black", width = 5, dash = "solid"),
  show_curve = TRUE,
  show_points = TRUE,
  point_marker = list(color = "black", size = 3, symbol = "circle"),
  scene = list(aspectmode = "data", xaxis = list(title = "x(t)"), yaxis = list(title =
    "y(t)"), zaxis = list(title = "z(t)")),
  bg = list(paper = "white", plot = "white"),
  tol = 1e-10
)
}
\arguments{
\item{X}{Function returning the \code{x} coordinate of the curve as a
function of the parameter \code{t}.}

\item{Y}{Function returning the \code{y} coordinate of the curve as a
function of the parameter \code{t}.}

\item{Z}{Function returning the \code{z} coordinate of the curve as a
function of the parameter \code{t}.}

\item{a}{Lower endpoint of the parameter interval.}

\item{b}{Upper endpoint of the parameter interval.}

\item{t_points}{Numeric vector of parameter values for evaluation and
optional plotting.}

\item{h}{Step size for centered finite-difference approximations.}

\item{plot}{Logical; if \code{TRUE}, produces a \pkg{plotly} 3D
visualization showing the curve and the binormal vectors.}

\item{n_samples}{Number of points used to sample and display the curve in
the plot.}

\item{vec_scale}{Base length used for binormal segments. If \code{NULL},
it is estimated as a small proportion of the size of the sampled curve.}

\item{vec_factor}{Multiplicative factor applied to \code{vec_scale} to
adjust segment length.}

\item{curve_line}{List with \pkg{plotly} style options for drawing the
base curve.}

\item{B_line}{List with \pkg{plotly} style options for the binormal
segments.}

\item{show_curve}{Logical; if \code{TRUE}, the base curve is included in
the plot.}

\item{show_points}{Logical; if \code{TRUE}, the evaluation points are
marked in the plot.}

\item{point_marker}{List with \pkg{plotly} marker options for the
evaluation points.}

\item{scene}{List with 3D scene settings for the \pkg{plotly} figure.}

\item{bg}{Background color configuration for the \pkg{plotly} figure.}

\item{tol}{Numeric tolerance for detecting situations in which the
derivative information is too weak to determine a stable binormal
direction.}
}
\value{
A tibble with columns \code{t}, \code{x}, \code{y}, \code{z},
\code{Bx}, \code{By} and \code{Bz}, containing the components of the
binormal vector at each evaluation point.
}
\description{
Computes numerical binormal vectors of a three-dimensional parametric
curve at selected parameter values. The curve is given by three coordinate
functions. At each evaluation point, the first and second derivatives of
the curve are approximated numerically, and their cross-product direction
is normalized to obtain the binormal vector.
}
\details{
For every value in \code{t_points}, the function:
\itemize{
\item computes centered finite-difference approximations of the first
and second derivatives,
\item forms a direction perpendicular to both derivatives,
\item normalizes that direction to obtain a unit binormal vector.
}

If the first derivative is extremely small or if the first and second
derivative vectors are nearly parallel, the binormal direction cannot be
determined reliably. In these cases, the function returns \code{NA} for
the affected components.

Optionally, the function can display the curve and the associated binormal
segments in an interactive 3D plot using \pkg{plotly}. The sampled curve,
evaluation points and binormal segments can be shown or hidden
independently.
}
\examples{
X <- function(t) t * cos(t)
Y <- function(t) t * sin(3 * t)
Z <- function(t) t
binormal3d(X, Y, Z, a = 0, b = 2 * pi, t_points = c(pi / 3, pi, 5 * pi / 3))

}
