% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.ave.mean2.dep}
\alias{se.ave.mean2.dep}
\title{Computes the standard error for the average of 2-group mean differences from
two parallel measurement response variables in the same sample}
\usage{
se.ave.mean2.dep(m1A, m2A, sd1A, sd2A, m1B, m2B, sd1B, sd2B, rAB, n1, n2)
}
\arguments{
\item{m1A}{estimated mean for variable A in group 1}

\item{m2A}{estimated mean for variable A in group 2}

\item{sd1A}{estimated standard deviation for variable A in group 1}

\item{sd2A}{estimated standard deviation for variable A in group 2}

\item{m1B}{estimated mean for variable B in group 1}

\item{m2B}{estimated mean for variable B in group 2}

\item{sd1B}{estimated standard deviation for variable B in group 1}

\item{sd2B}{estimated standard deviation for variable B in group 2}

\item{rAB}{estimated within-group correlation between variables A and B}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated average mean difference
\item SE - standard error
\item VAR(A) - variance of mean difference for variable A
\item VAR(B) - variance of mean difference for variable B
\item COV(A,B) - covariance of mean differences for variables A and B
}
}
\description{
In a study that reports a 2-group mean difference for two response
variables that satisfy the conditions of parallel measurments, this function
can be used to compute the standard error of the average of the two mean
differences using the two estimated means, estimated standard deviations,
estimated within-group correlation between the two response variables, and
the two sample sizes. The average mean difference and standard error output
from this function can then be used as input in the
\link[vcmeta]{meta.ave.gen}, \link[vcmeta]{meta.lc.gen}, and
\link[vcmeta]{meta.lm.gen} functions in a meta-analysis where some studies
have used one of the two parallel response variables and other studies have
used the other parallel response variable. Equality of variances is not
assumed.
}
\examples{
se.ave.mean2.dep(21.9, 16.1, 3.82, 3.21, 24.8, 17.1, 3.57, 3.64, .785, 40, 40)

# Should return:
#                          Estimate        SE    VAR(A)    VAR(B)  COV(A,B)
# Average mean difference:     6.75 0.7526878 0.6224125 0.6498625 0.4969403


}
