% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Cancer}
\alias{Cancer}
\title{Survival of Breast Cancer Patients}
\format{
A 3-dimensional array resulting from cross-tabulating 3 variables
for 474 observations. The variable names and their levels are:

\tabular{rll}{
dim \tab Name \tab Levels \cr
1\tab \code{Survival}\tab  \verb{"Died", "Surv"}\cr
2\tab \code{Grade}\tab \verb{"Malignant", "Benign"}\cr
3\tab \code{Center}\tab \verb{"Boston", "Glamorgan"}\cr
}
}
\source{
Lindsey, J. K. (1995).
Analysis of Frequency and Count Data Oxford, UK: Oxford University Press. p.
38, Table 2.5.

Whittaker, J. (1990) Graphical Models in Applied Multivariate Statistics New
York: John Wiley and Sons, p. 220.
}
\description{
Three year survival of 474 breast cancer patients according to nuclear grade
and diagnostic center.
}
\examples{

data(Cancer)

MASS::loglm(~Survival + Grade + Center, data = Cancer)

vcd::mosaic(Cancer, shade=TRUE)

}
\keyword{datasets}
