% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_integration.R
\name{legend_bracket}
\alias{legend_bracket}
\title{Add legend with brackets to a ggplot object}
\usage{
legend_bracket(
  labels,
  colors,
  comparisons = NULL,
  x = NULL,
  y = NULL,
  width = NULL,
  height = NULL,
  unit = "npc",
  position = "topleft",
  title = NULL,
  text_size = 10,
  text_family = "sans",
  text_face = "plain",
  title_size = 11,
  title_face = "bold",
  sig_size = 11,
  sig_face = "plain",
  output_width = NULL,
  output_height = NULL,
  bracket_margin = NULL,
  legend_x = NULL,
  legend_y = NULL
)
}
\arguments{
\item{labels}{Character vector of group names (in order)}

\item{colors}{Character vector of colors matching the groups}

\item{comparisons}{Data frame with columns: group1, group2, label}

\item{x}{Numeric. X position of legend (0-1 scale or with unit)}

\item{y}{Numeric. Y position of legend (0-1 scale or with unit)}

\item{width}{Numeric. Width of legend box (default NULL = auto)}

\item{height}{Numeric. Height of legend box (default NULL = auto)}

\item{unit}{Character. Unit for width and height: "npc" (0-1 scale), "in", "cm", "mm" (default "npc")}

\item{position}{Character. Preset position: "topleft", "topright", "bottomleft", "bottomright", or NULL for manual x/y}

\item{title}{Character. Legend title (optional)}

\item{text_size}{Numeric. Font size for labels (default 10)}

\item{text_family}{Character. Font family (default "sans")}

\item{text_face}{Character. Font face (default "plain")}

\item{title_size}{Numeric. Title font size (default 11)}

\item{title_face}{Character. Title font face (default "bold")}

\item{sig_size}{Numeric. Significance symbol size (default 11)}

\item{sig_face}{Character. Significance symbol face (default "plain")}

\item{output_width}{Numeric. Output figure width in inches (for accurate bracket positioning)}

\item{output_height}{Numeric. Output figure height in inches (for accurate bracket positioning)}

\item{bracket_margin}{Numeric. Custom horizontal spacing between legend text and brackets (default NULL = auto-adaptive)}

\item{legend_x}{Numeric. Custom X position for legend box (0-1 scale, overrides adaptive positioning)}

\item{legend_y}{Numeric. Custom Y position for legend box (0-1 scale, overrides adaptive positioning)}
}
\value{
A vbracket_legend object
}
\description{
This function allows you to add a custom legend with brackets using
the + operator, similar to ggplot2 layers.
}
\examples{
\donttest{
library(ggplot2)
data <- data.frame(x = 1:10, y = 1:10, group = rep(c("A", "B"), each = 5))
labels <- c("A", "B")
colors <- c("A" = "red", "B" = "blue")
comparisons <- add_bracket_comparisons(groups1 = "A", groups2 = "B", labels = "*")

p <- ggplot(data, aes(x, y, color = group)) + geom_point() +
  legend_bracket(labels, colors, comparisons,
                 position = "topleft",
                 output_width = 6, output_height = 4)

# Then use regular ggsave with same dimensions
ggsave(file.path(tempdir(), "plot.pdf"), p, width = 6, height = 4)
}
}
