% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/uptimerobot.monitors.R
\name{uptimerobot.monitors}
\alias{uptimerobot.monitors}
\title{Get general informations about monitors}
\usage{
uptimerobot.monitors(api.key, monitors = NULL, types = NULL,
  statuses = NULL, search = NULL, summary = list(), limit = 50,
  offset = 0, fields = uptimerobot.fields("monitor")$typical)
}
\arguments{
\item{api.key}{A valid key for connecting to UptimeRobors public API.}

\item{monitors}{vector or comma-delimited string with the IDs of the monitors to get. If not used or set to \code{NULL}, will return all monitors in an account.}

\item{types}{vector or comma-delimited string of monitor types. If not used or set to \code{NULL}, the function will return all monitors types (HTTP, keyword, ping..) in an account. Else, it is possible to define any number of monitor types. You can use both the friendly name (string) or the index (integer) here.}

\item{statuses}{vector or comma-delimited string of monitor statuses. If not used or set to \code{NULL}, the function will return  all monitors statuses (up, down, paused) in an account. Else, it is possible to define any number of monitor statuses. You can use both the friendly name (string) or the index (integer) here.}

\item{search}{An optional keyword of to search within monitor URL or friendly name to get filtered results.}

\item{summary}{list of logical values to flag summary indicators to add to the output dataset.}

\item{limit}{An integer value used for pagination. Defines the max number of records to return in each page. Default and max. is 50.}

\item{offset}{An integer value to set the index of the first monitor to get (used for pagination).}

\item{fields}{vector or comma-delimited string with the general informations to include in the output dataset.
You may want to use the helper function \code{\link{uptimerobot.fields}} if you don't want to manually compile the list of fields.}
}
\value{
A dataset with general informations about the given monitors
}
\description{
\code{uptimerobots.monitors.responses} return a dataset with general informations
for a set of monitors.
}
\details{
If a vector of monitor is not given, the function will return data for all the available monitors.

\code{summary} parameter expect a lists of three named logic values that set which columns of additional statistics for each monitor must  be added to output dataset for
each available monitor. These are summary values only, as the instances are obtained using a set of dedicated functions.

\enumerate{
  \item \code{response.times} set to \code{TRUE} to add a column with the number of pings with response times available for the monitor to the output. These values can be queried using \code{\link{uptimerobot.monitor.responses}} function.
  \item \code{log.records} set to \code{TRUE} to add a column with the number of log entries recorded for the monitor to the output. These records can be queried using \code{\link{uptimerobot.monitor.logs}} function.
  \item \code{alert.contacts} set to \code{TRUE} to add a column with the number of alert contacts binded to the monitor to the output. Detailed informations about these contacts can be queried using \code{\link{uptimerobot.monitor.contacts}} function.
}

You may just add the elements you want to include into the list, as they default to \code{FALSE} if missing. Set an empty list to exclude all the summary statistics from the output.

The API uses pagination and returns no more than 50 monitors on each page. Use \code{limit} and \code{offset} to set a different number of
monitors to get on each page and to move between pages. Leave default values to get all the data.
}
\examples{
\dontrun{
# Let's assume the api.key is available into the environment variable KEY
api.key <- Sys.getenv("KEY", "")

# Returns all the  monitors with a default set of attributes
monitors.df <- uptimerobot.monitors(api.key)

#' # Returns all the monitors of 'keyword' type
monitors.kwd..df <- uptimerobot.monitors(api.key, type="keyword")

# Returns all the monitors and all the attributes
monitors.full.df <- uptimerobot.monitors(api.key, fields=uptimerobot.fields("monitor")$full))

# Returns only the two monitors with ID: 1234, 5678
monitors.df <- uptimerobot.monitors(api.key, c("1234", "5678"))
}
}
\author{
Gabriele Baldassarre
}
\seealso{
\code{\link{uptimerobot.monitor.responses}}, \code{\link{uptimerobot.monitor.logs}}, \code{\link{uptimerobot.monitor.contacts}}
}

